/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ENumberConst;
import com.mysema.query.types.expr.ETime;
import java.sql.Time;
import java.util.Calendar;

public class ETimeConst
extends ETime<Time>
implements Constant<Time> {
    private final Calendar calendar = Calendar.getInstance();
    private final Time time;

    public static ETime<Time> create(Time time) {
        return new ETimeConst(time);
    }

    public ETimeConst(Time time) {
        super(Time.class);
        this.time = time;
        this.calendar.setTime(time);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<Integer> getHour() {
        return ENumberConst.create(this.calendar.get(11));
    }

    @Override
    public ENumber<Integer> getMinute() {
        return ENumberConst.create(this.calendar.get(12));
    }

    @Override
    public ENumber<Integer> getSecond() {
        return ENumberConst.create(this.calendar.get(13));
    }

    @Override
    public ENumber<Integer> getMilliSecond() {
        return ENumberConst.create(this.calendar.get(14));
    }

    @Override
    public Time getConstant() {
        return this.time;
    }
}

