/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EBooleanConst;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.util.MathUtils;

public class ENumberConst<D extends Number>
extends ENumber<D>
implements Constant<D> {
    private static final ENumber<Byte>[] bytes = new ENumber[256];
    private static final ENumber<Integer>[] ints = new ENumber[256];
    private static final ENumber<Long>[] longs = new ENumber[256];
    private static final ENumber<Short>[] shorts = new ENumber[256];
    private final D constant;

    public static ENumber<Byte> create(byte i) {
        if (i >= 0 && i < 256) {
            return bytes[i];
        }
        return new ENumberConst<Byte>(Byte.class, i);
    }

    public static ENumber<Integer> create(int i) {
        if (i >= 0 && i < 256) {
            return ints[i];
        }
        return new ENumberConst<Integer>(Integer.class, i);
    }

    public static ENumber<Long> create(long i) {
        if (i >= 0L && i < 256L) {
            return longs[(int)i];
        }
        return new ENumberConst<Long>(Long.class, i);
    }

    public static ENumber<Short> create(short i) {
        if (i >= 0 && i < 256) {
            return shorts[i];
        }
        return new ENumberConst<Short>(Short.class, i);
    }

    public static <T extends Number> ENumber<T> create(T val) {
        return new ENumberConst<Number>(val.getClass(), (Number)Assert.notNull(val, (String)"val is null"));
    }

    ENumberConst(Class<? extends D> type, D constant) {
        super(type);
        this.constant = constant;
    }

    @Override
    public EBoolean eq(D b) {
        return EBooleanConst.create(this.constant.equals(b));
    }

    public boolean equals(Object o) {
        return o instanceof Constant ? ((Constant)o).getConstant().equals(this.constant) : false;
    }

    @Override
    public D getConstant() {
        return this.constant;
    }

    @Override
    public int hashCode() {
        return this.constant.hashCode();
    }

    @Override
    public EBoolean ne(D b) {
        return EBooleanConst.create(!this.constant.equals(b));
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<D> add(Number right) {
        return ENumberConst.create(MathUtils.sum(this.constant, right));
    }

    @Override
    public <N extends Number> ENumber<D> add(Expr<N> right) {
        if (right instanceof Constant) {
            return this.add((Number)((Constant)((Object)right)).getConstant());
        }
        return super.add(right);
    }

    @Override
    public ENumber<D> subtract(Number right) {
        return ENumberConst.create(MathUtils.difference(this.constant, right));
    }

    @Override
    public <N extends Number> ENumber<D> subtract(Expr<N> right) {
        if (right instanceof Constant) {
            return this.subtract((Number)((Constant)((Object)right)).getConstant());
        }
        return super.subtract(right);
    }

    @Override
    public ENumber<Byte> byteValue() {
        return ENumberConst.create(((Number)this.constant).byteValue());
    }

    @Override
    public ENumber<Double> doubleValue() {
        return ENumberConst.create(((Number)this.constant).doubleValue());
    }

    @Override
    public ENumber<Float> floatValue() {
        return ENumberConst.create(Float.valueOf(((Number)this.constant).floatValue()));
    }

    @Override
    public ENumber<Long> longValue() {
        return ENumberConst.create(((Number)this.constant).longValue());
    }

    @Override
    public ENumber<Short> shortValue() {
        return ENumberConst.create(((Number)this.constant).shortValue());
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ENumberConst.ints[i] = new ENumberConst<Integer>(Integer.class, i);
            ENumberConst.shorts[i] = new ENumberConst<Short>(Short.class, (short)i);
            ENumberConst.bytes[i] = new ENumberConst<Byte>(Byte.class, (byte)i);
            ENumberConst.longs[i] = new ENumberConst<Long>(Long.class, Long.valueOf(i));
        }
    }
}

