/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.codegen.SimpleClassTypeModel;
import com.mysema.query.codegen.SimpleTypeModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import com.mysema.query.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;

public class TypeModelFactory {
    private final Collection<Class<? extends Annotation>> entityAnnotations;
    private final Map<List<Type>, TypeModel> cache = new HashMap<List<Type>, TypeModel>();

    public TypeModelFactory(Class<?> ... entityAnnotations) {
        this.entityAnnotations = Arrays.asList(entityAnnotations);
    }

    public TypeModelFactory(List<Class<? extends Annotation>> entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public TypeModel create(Class<?> cl) {
        return this.create(cl, cl);
    }

    public TypeModel create(Class<?> cl, Type genericType) {
        TypeModel valueInfo;
        TypeModel value;
        List<Type> key = Arrays.asList(cl, genericType);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        if (cl.isPrimitive()) {
            cl = ClassUtils.primitiveToWrapper(cl);
        }
        boolean entity = false;
        for (Class<? extends Annotation> clazz : this.entityAnnotations) {
            if (cl.getAnnotation(clazz) == null) continue;
            entity = true;
            break;
        }
        if (entity) {
            value = new SimpleClassTypeModel(TypeCategory.ENTITY, cl);
        } else if (cl.isArray()) {
            value = this.createArrayType(this.create(cl.getComponentType()));
        } else if (cl.isEnum()) {
            value = new SimpleClassTypeModel(TypeCategory.SIMPLE, cl);
        } else if (Map.class.isAssignableFrom(cl)) {
            TypeModel keyInfo = this.create(TypeUtil.getTypeParameter(genericType, 0));
            TypeModel valueInfo2 = this.create(TypeUtil.getTypeParameter(genericType, 1));
            value = this.createMapType(keyInfo, valueInfo2);
        } else if (List.class.isAssignableFrom(cl)) {
            valueInfo = this.create(TypeUtil.getTypeParameter(genericType, 0));
            value = this.createListType(valueInfo);
        } else if (Collection.class.isAssignableFrom(cl)) {
            valueInfo = this.create(TypeUtil.getTypeParameter(genericType, 0));
            value = this.createCollectionType(valueInfo);
        } else if (Number.class.isAssignableFrom(cl) && Comparable.class.isAssignableFrom(cl)) {
            value = new SimpleClassTypeModel(TypeCategory.NUMERIC, cl);
        } else {
            TypeCategory typeCategory = TypeCategory.get(cl.getName());
            if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && Comparable.class.isAssignableFrom(cl)) {
                typeCategory = TypeCategory.COMPARABLE;
            }
            value = new SimpleClassTypeModel(typeCategory, cl);
        }
        this.cache.put(key, value);
        return value;
    }

    public TypeModel createArrayType(TypeModel valueType) {
        return this.createComposite(TypeCategory.ENTITYCOLLECTION, TypeCategory.SIMPLECOLLECTION, Collection.class, valueType);
    }

    public TypeModel createCollectionType(TypeModel valueType) {
        return this.createComposite(TypeCategory.ENTITYCOLLECTION, TypeCategory.SIMPLECOLLECTION, Collection.class, valueType);
    }

    private TypeModel createComposite(TypeCategory entity, TypeCategory simple, Class<?> containerType, TypeModel ... parameters) {
        TypeModel value = parameters[parameters.length - 1];
        TypeCategory category = value.getTypeCategory() == TypeCategory.ENTITY ? entity : simple;
        return new SimpleTypeModel(category, containerType.getName(), containerType.getPackage().getName(), containerType.getSimpleName(), Modifier.isFinal(containerType.getModifiers()), parameters);
    }

    public TypeModel createListType(TypeModel valueType) {
        return this.createComposite(TypeCategory.ENTITYLIST, TypeCategory.SIMPLELIST, List.class, valueType);
    }

    public TypeModel createMapType(TypeModel keyType, TypeModel valueType) {
        return this.createComposite(TypeCategory.ENTITYMAP, TypeCategory.SIMPLEMAP, Map.class, keyType, valueType);
    }
}

