/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.ClassUtils;

@Immutable
public class SimpleClassTypeModel
implements TypeModel {
    private final Class<?> clazz;
    private final List<TypeModel> parameters;
    private final Class<?> primitiveClass;
    private final TypeCategory typeCategory;
    private final boolean visible;

    public SimpleClassTypeModel(TypeCategory typeCategory, Class<?> clazz) {
        this(typeCategory, clazz, ClassUtils.wrapperToPrimitive(clazz));
    }

    public SimpleClassTypeModel(TypeCategory typeCategory, Class<?> clazz, Class<?> primitiveClass) {
        this.typeCategory = (TypeCategory)((Object)Assert.notNull((Object)((Object)typeCategory)));
        this.clazz = (Class)Assert.notNull(clazz);
        this.primitiveClass = primitiveClass;
        this.parameters = Collections.emptyList();
        this.visible = clazz.getPackage().getName().equals("java.lang");
    }

    @Override
    public TypeModel as(TypeCategory category) {
        if (this.typeCategory == category) {
            return this;
        }
        return new SimpleClassTypeModel(category, this.clazz);
    }

    @Override
    public String getFullName() {
        return this.clazz.getName();
    }

    @Override
    public StringBuilder getLocalGenericName(TypeModel context, StringBuilder builder, boolean asArgType) {
        return this.getLocalRawName(context, builder);
    }

    @Override
    public StringBuilder getLocalRawName(TypeModel context, StringBuilder builder) {
        if (this.visible || context.getPackageName().equals(this.clazz.getPackage().getName())) {
            builder.append(this.clazz.getName().substring(this.clazz.getPackage().getName().length() + 1));
        } else {
            builder.append(this.clazz.getName());
        }
        return builder;
    }

    @Override
    public String getPackageName() {
        return this.clazz.getPackage().getName();
    }

    @Override
    public TypeModel getParameter(int i) {
        return this.parameters.get(i);
    }

    @Override
    public int getParameterCount() {
        return this.parameters.size();
    }

    @Override
    public String getPrimitiveName() {
        return this.primitiveClass != null ? this.primitiveClass.getSimpleName() : null;
    }

    @Override
    public TypeModel getSelfOrValueType() {
        if (this.typeCategory.isSubCategoryOf(TypeCategory.COLLECTION) || this.typeCategory.isSubCategoryOf(TypeCategory.MAP)) {
            return this.parameters.get(this.parameters.size() - 1);
        }
        return this;
    }

    @Override
    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    @Override
    public TypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    @Override
    public boolean isPrimitive() {
        return this.primitiveClass != null;
    }

    public boolean equals(Object o) {
        if (o instanceof TypeModel) {
            TypeModel t = (TypeModel)o;
            return this.clazz.getName().equals(t.getFullName());
        }
        return false;
    }

    public int hashCode() {
        return this.clazz.getName().hashCode();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.clazz.getModifiers());
    }

    @Override
    public boolean hasEntityFields() {
        return false;
    }

    @Override
    public String getQueryTypeName(EntityModel context) {
        return null;
    }
}

