/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import com.mysema.util.JavaSyntaxUtils;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public final class PropertyModel
implements Comparable<PropertyModel> {
    private final EntityModel context;
    private final boolean inherited;
    private final String name;
    private final String escapedName;
    private final String typeName;
    @Nullable
    private final String queryTypeName;
    private final TypeModel propertyType;
    private final String[] inits;

    public PropertyModel(EntityModel classModel, String name, TypeModel type, String[] inits) {
        this(classModel, name, type, inits, false);
    }

    public PropertyModel(EntityModel classModel, String name, TypeModel type, String[] inits, boolean inherited) {
        this.context = classModel;
        this.name = (String)Assert.notNull((Object)name);
        this.escapedName = JavaSyntaxUtils.isReserved(name) ? name + "_" : name;
        this.propertyType = (TypeModel)Assert.notNull((Object)type);
        this.typeName = type.getLocalRawName(classModel, new StringBuilder()).toString();
        this.inits = inits;
        this.inherited = inherited;
        this.queryTypeName = type.getQueryTypeName(this.context);
    }

    @Override
    public int compareTo(PropertyModel o) {
        return this.name.compareToIgnoreCase(o.getName());
    }

    public PropertyModel createCopy(EntityModel model) {
        boolean inherited = model.getSuperModel() != null;
        return new PropertyModel(model, this.name, this.propertyType, this.inits, inherited);
    }

    public boolean equals(Object o) {
        return o instanceof PropertyModel && this.name.equals(((PropertyModel)o).name);
    }

    public String getEscapedName() {
        return this.escapedName;
    }

    @Nullable
    public String getGenericParameterName(int i) {
        return this.getGenericParameterName(i, false);
    }

    @Nullable
    public String getGenericParameterName(int i, boolean asArgType) {
        if (i < this.propertyType.getParameterCount()) {
            return this.propertyType.getParameter(i).getLocalGenericName(this.context, new StringBuilder(), asArgType).toString();
        }
        return null;
    }

    public String getGenericTypeName() {
        return this.propertyType.getLocalGenericName(this.context, new StringBuilder(), false).toString();
    }

    public String[] getInits() {
        return this.inits;
    }

    public EntityModel getBeanModel() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getRawParameterName(int i) {
        if (i < this.propertyType.getParameterCount()) {
            return this.propertyType.getParameter(i).getLocalRawName(this.context, new StringBuilder()).toString();
        }
        return null;
    }

    public String getQueryTypeName() {
        return this.queryTypeName;
    }

    public String getSimpleTypeName() {
        return this.propertyType.getSimpleName();
    }

    public TypeCategory getTypeCategory() {
        return this.propertyType.getTypeCategory();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypePackage() {
        return this.propertyType.getPackageName();
    }

    public int hashCode() {
        return ((Object)Arrays.asList(this.name, this.propertyType)).hashCode();
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String toString() {
        return this.context.getFullName() + "." + this.name;
    }

    public boolean hasEntityFields() {
        return this.propertyType.hasEntityFields();
    }
}

