/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.ParameterModel;
import com.mysema.query.codegen.Serializer;
import java.io.IOException;
import java.io.Writer;
import net.jcip.annotations.Immutable;

@Immutable
public class DTOSerializer
implements Serializer {
    @Override
    public void serialize(EntityModel model, Writer writer) throws IOException {
        this.intro(model, writer);
        String simpleName = model.getSimpleName();
        String queryType = model.getPrefix() + simpleName;
        String localName = model.getLocalRawName();
        StringBuilder builder = new StringBuilder();
        for (ConstructorModel c : model.getConstructors()) {
            builder.append("    public " + queryType + "(");
            boolean first = true;
            for (ParameterModel p : c.getParameters()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("Expr<");
                if (!p.getType().isFinal()) {
                    builder.append("? extends ");
                }
                builder = p.getType().getLocalGenericName(model, builder, false);
                builder.append("> ").append(p.getName());
                first = false;
            }
            builder.append("){\n");
            builder.append("        super(" + localName + ".class");
            builder.append(", new Class[]{");
            first = true;
            for (ParameterModel p : c.getParameters()) {
                if (!first) {
                    builder.append(",");
                }
                if (p.getType().getPrimitiveName() != null) {
                    builder.append(p.getType().getPrimitiveName() + ".class");
                } else {
                    builder = p.getType().getLocalRawName(model, builder);
                    builder.append(".class");
                }
                first = false;
            }
            builder.append("}");
            for (ParameterModel p : c.getParameters()) {
                builder.append(", " + p.getName());
            }
            builder.append(");\n");
            builder.append("    }\n\n");
        }
        writer.append(builder.toString());
        this.outro(model, writer);
    }

    protected void intro(EntityModel model, Writer writer) throws IOException {
        String simpleName = model.getSimpleName();
        String queryType = model.getPrefix() + simpleName;
        String localName = model.getLocalRawName();
        StringBuilder builder = new StringBuilder();
        builder.append("package " + model.getPackageName() + ";\n\n");
        builder.append("import com.mysema.query.types.expr.*;\n\n");
        builder.append("/**\n");
        builder.append(" * " + queryType + " is a Querydsl DTO type for " + simpleName + "\n");
        builder.append(" * \n");
        builder.append(" */ \n");
        builder.append("@SuppressWarnings(\"serial\")\n");
        builder.append("public class " + queryType + " extends EConstructor<" + localName + ">{\n\n");
        writer.append(builder.toString());
    }

    protected void outro(EntityModel model, Writer writer) throws IOException {
        writer.write("}\n");
    }
}

