/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FactoryMap<V> {
    private final Map<List<?>, V> cache = new HashMap();
    private Method createMethod;

    public FactoryMap() {
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().equals("create")) continue;
            this.createMethod = m;
        }
        if (this.createMethod == null) {
            throw new IllegalArgumentException("No create method given");
        }
        this.createMethod.setAccessible(true);
    }

    public final V get(Object ... args) {
        List<Object> key = Arrays.asList(args);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        try {
            Object value = this.createMethod.invoke((Object)this, args);
            this.cache.put(key, value);
            return (V)value;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void clear() {
        this.cache.clear();
    }
}

