/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.util.NotEmpty;
import java.lang.reflect.Array;
import javax.annotation.Nonnegative;

public abstract class PArray<D>
extends Expr<D[]>
implements Path<D[]> {
    protected final Class<D[]> arrayType;
    protected final Class<D> componentType;
    private volatile EBoolean isnull;
    private volatile EBoolean isnotnull;
    private final PathMetadata<?> metadata;
    private volatile ENumber<Integer> size;
    private final Path<?> root;

    public PArray(Class<D> type, PathMetadata<?> metadata) {
        super(Object[].class);
        this.arrayType = Array.newInstance(type, 0).getClass();
        this.componentType = type;
        this.metadata = metadata;
        this.root = metadata.getRoot() != null ? metadata.getRoot() : this;
    }

    public PArray(Class<D> type, @NotEmpty String var) {
        this(type, PathMetadata.forVariable(var));
    }

    public boolean equals(Object o) {
        return o instanceof Path ? ((Path)o).getMetadata().equals(this.metadata) : false;
    }

    public abstract Expr<D> get(Expr<Integer> var1);

    public abstract Expr<D> get(@Nonnegative int var1);

    public Class<D> getElementType() {
        return this.componentType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public Class<D[]> getType() {
        return this.arrayType;
    }

    @Override
    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }

    public ENumber<Integer> size() {
        if (this.size == null) {
            this.size = ONumber.create(Integer.class, Ops.COL_SIZE, this);
        }
        return this.size;
    }
}

