/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Templates;
import com.mysema.query.types.ToStringVisitor;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ECollection;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public abstract class Expr<D>
implements Serializable {
    private static final Templates templates = new Templates();
    private volatile ENumber<Long> count;
    private final boolean primitive;
    private volatile String toString;
    private final Class<? extends D> type;

    public static ENumber<Long> countAll() {
        return Ops.AggOps.COUNT_ALL_AGG_EXPR;
    }

    public Expr(Class<? extends D> type) {
        this.type = (Class)Assert.notNull(type, (String)"type is null");
        this.primitive = type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class.equals(type) || Character.class.equals(type);
    }

    public abstract void accept(Visitor var1);

    public ENumber<Long> count() {
        if (this.count == null) {
            this.count = ONumber.create(Long.class, Ops.AggOps.COUNT_AGG, this);
        }
        return this.count;
    }

    public EBoolean eq(D right) {
        return this.eq(ExprConst.create(right));
    }

    public final EBoolean eq(Expr<? super D> right) {
        if (this.primitive) {
            return OBoolean.create(Ops.EQ_PRIMITIVE, this, right);
        }
        return OBoolean.create(Ops.EQ_OBJECT, this, right);
    }

    public Class<? extends D> getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : super.hashCode();
    }

    public final EBoolean in(Collection<? extends D> right) {
        if (right.size() == 1) {
            return this.eq(right.iterator().next());
        }
        return OBoolean.create(Ops.IN, this, ExprConst.create(right));
    }

    public final EBoolean in(D ... right) {
        if (right.length == 1) {
            return this.eq(right[0]);
        }
        return OBoolean.create(Ops.IN, this, ExprConst.create(Arrays.asList(right)));
    }

    public final EBoolean in(ECollection<? extends D> right) {
        return OBoolean.create(Ops.IN, this, (Expr)((Object)right));
    }

    public EBoolean ne(D right) {
        return this.ne(ExprConst.create(right));
    }

    public final EBoolean ne(Expr<? super D> right) {
        if (this.primitive) {
            return OBoolean.create(Ops.NE_PRIMITIVE, this, right);
        }
        return OBoolean.create(Ops.NE_OBJECT, this, right);
    }

    public final EBoolean notIn(Collection<? extends D> right) {
        if (right.size() == 1) {
            return this.ne(right.iterator().next());
        }
        return this.in(right).not();
    }

    public final EBoolean notIn(D ... right) {
        if (right.length == 1) {
            return this.ne(right[0]);
        }
        return this.in(right).not();
    }

    public final EBoolean notIn(ECollection<? extends D> right) {
        return this.in(right).not();
    }

    public final String toString() {
        if (this.toString == null) {
            this.toString = ((ToStringVisitor)new ToStringVisitor(templates).handle(this)).toString();
        }
        return this.toString;
    }
}

