/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.codegen.BeanModel;
import com.mysema.query.codegen.EntitySerializer;
import java.io.IOException;
import java.io.Writer;
import net.jcip.annotations.Immutable;

@Immutable
public class SupertypeSerializer
extends EntitySerializer {
    @Override
    protected void constructors(BeanModel model, Writer writer) throws IOException {
        String simpleName = model.getSimpleName();
        String queryType = model.getPrefix() + simpleName;
        String genericName = model.getLocalGenericName();
        StringBuilder builder = new StringBuilder();
        if (!model.hasEntityFields()) {
            builder.append("    public " + queryType + "(PEntity<? extends " + genericName + "> entity){\n");
            builder.append("        super(entity.getType(), entity.getEntityName(), entity.getMetadata());\n");
            builder.append("    }\n\n");
        } else {
            builder.append("    public " + queryType + "(Class<? extends " + genericName + "> type, @NotEmpty String entityName, PathMetadata<?> metadata, PathInits inits) {\n");
            builder.append("        super(type, entityName, metadata);\n");
            if (model.hasEntityFields()) {
                this.initEntityFields(builder, model);
            }
            builder.append("    }\n");
        }
        writer.append(builder.toString());
    }

    @Override
    protected void introDefaultInstance(StringBuilder builder, BeanModel model) {
    }

    @Override
    protected void introFactoryMethods(StringBuilder builder, BeanModel model) throws IOException {
    }

    @Override
    protected void introImports(StringBuilder builder, BeanModel model) {
        if (model.hasEntityFields()) {
            builder.append("import com.mysema.query.util.*;\n");
        }
        builder.append("import com.mysema.query.types.path.*;\n\n");
        if (model.hasLists() || model.hasMaps()) {
            builder.append("import com.mysema.query.types.expr.*;\n");
        }
    }

    @Override
    protected void introInits(StringBuilder builder, BeanModel model) {
    }
}

