/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.PropertyModel;
import com.mysema.query.codegen.TypeModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class BeanModel
implements Comparable<BeanModel> {
    private final Collection<ConstructorModel> constructors = new HashSet<ConstructorModel>();
    private int escapeSuffix = 1;
    private boolean hasLists;
    private boolean hasMaps;
    private boolean hasEntityFields;
    private final String prefix;
    private final Set<PropertyModel> properties = new TreeSet<PropertyModel>();
    @Nullable
    private BeanModel superModel;
    private final Collection<String> superTypes;
    private final TypeModel typeModel;
    private String uncapSimpleName;

    public BeanModel(String prefix, TypeModel typeModel) {
        this(prefix, typeModel, Collections.emptyList());
    }

    public BeanModel(String prefix, TypeModel typeModel, Collection<String> superTypes) {
        this.prefix = (String)Assert.notNull((Object)prefix);
        this.typeModel = typeModel;
        this.uncapSimpleName = StringUtils.uncapitalize((String)typeModel.getSimpleName());
        this.superTypes = superTypes;
    }

    public void addConstructor(ConstructorModel co) {
        this.constructors.add(co);
    }

    public void addProperty(PropertyModel field) {
        this.properties.add(this.validateField(field));
        switch (field.getTypeCategory()) {
            case ENTITYMAP: 
            case SIMPLEMAP: {
                this.hasMaps = true;
                break;
            }
            case ENTITYLIST: 
            case SIMPLELIST: {
                this.hasLists = true;
                break;
            }
            case ENTITY: {
                this.hasEntityFields = true;
            }
        }
    }

    @Override
    public int compareTo(BeanModel o) {
        return this.typeModel.getSimpleName().compareTo(o.typeModel.getSimpleName());
    }

    public boolean equals(Object o) {
        return o instanceof BeanModel && this.typeModel.equals(((BeanModel)o).typeModel);
    }

    public Collection<ConstructorModel> getConstructors() {
        return this.constructors;
    }

    public String getLocalGenericName() {
        return this.typeModel.getLocalGenericName(this, new StringBuilder(), false).toString();
    }

    public String getLocalRawName() {
        return this.typeModel.getLocalRawName(this, new StringBuilder()).toString();
    }

    public String getFullName() {
        return this.typeModel.getFullName();
    }

    public Set<PropertyModel> getProperties() {
        return this.properties;
    }

    public String getPackageName() {
        return this.typeModel.getPackageName();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSimpleName() {
        return this.typeModel.getSimpleName();
    }

    @Nullable
    public BeanModel getSuperModel() {
        return this.superModel;
    }

    public Collection<String> getSuperTypes() {
        return this.superTypes;
    }

    public String getUncapSimpleName() {
        return this.uncapSimpleName;
    }

    public boolean hasEntityFields() {
        return this.hasEntityFields;
    }

    public int hashCode() {
        return this.typeModel.hashCode();
    }

    public boolean hasLists() {
        return this.hasLists;
    }

    public boolean hasMaps() {
        return this.hasMaps;
    }

    public void include(BeanModel clazz) {
        for (PropertyModel property : clazz.properties) {
            if (property.isInherited()) continue;
            this.addProperty(property.createCopy(this));
        }
    }

    public void setSuperModel(BeanModel superModel) {
        this.superModel = superModel;
    }

    private PropertyModel validateField(PropertyModel field) {
        if (field.getName().equals(this.uncapSimpleName)) {
            this.uncapSimpleName = StringUtils.uncapitalize((String)this.typeModel.getSimpleName()) + this.escapeSuffix++;
        }
        return field;
    }
}

