/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.TypeCategory;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public final class TypeModel {
    private final TypeCategory typeCategory;
    private final String name;
    private final String packageName;
    private final String simpleName;
    private final String localName;
    @Nullable
    private final TypeModel keyType;
    @Nullable
    private final TypeModel valueType;

    public TypeModel(TypeCategory typeCategory, Class<?> clazz) {
        this(typeCategory, clazz.getName(), clazz.getPackage().getName(), clazz.getSimpleName(), null, null);
    }

    public TypeModel(TypeCategory typeCategory, String name, String packageName, String simpleName, @Nullable TypeModel keyType, @Nullable TypeModel valueType) {
        this.typeCategory = (TypeCategory)((Object)Assert.notNull((Object)((Object)typeCategory), (String)"typeCategory is null"));
        this.name = (String)Assert.notNull((Object)name, (String)"name is null");
        this.packageName = (String)Assert.notNull((Object)packageName, (String)"packageName is null");
        this.simpleName = (String)Assert.notNull((Object)simpleName, (String)"simpleName is null");
        this.localName = name.substring(packageName.length() + 1);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public TypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    public String getName() {
        return this.name;
    }

    public TypeModel getKeyType() {
        return this.keyType;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public TypeModel getValueType() {
        return this.valueType;
    }

    public String toString() {
        return this.name;
    }

    public TypeModel as(TypeCategory category) {
        if (this.typeCategory == category) {
            return this;
        }
        return new TypeModel(category, this.name, this.packageName, this.simpleName, this.keyType, this.valueType);
    }
}

