/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.ClassModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import com.mysema.util.JavaSyntaxUtils;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public final class FieldModel
implements Comparable<FieldModel> {
    private final ClassModel classModel;
    private final String name;
    private final String escapedName;
    private final String typeName;
    private final String keyTypeName;
    private final String valueTypeName;
    @Nullable
    private final String queryTypeName;
    @Nullable
    private final String docs;
    private final TypeModel type;

    public FieldModel(ClassModel classModel, String name, TypeModel type, @Nullable String docs) {
        this.classModel = classModel;
        this.name = (String)Assert.notNull((Object)name);
        this.escapedName = JavaSyntaxUtils.isReserved(name) ? name + "_" : name;
        this.type = (TypeModel)Assert.notNull((Object)type);
        this.docs = docs != null ? docs.replace("@return", "").trim() : null;
        this.typeName = this.getLocalName(type);
        this.keyTypeName = type.getKeyType() != null ? this.getLocalName(type.getKeyType()) : null;
        String string = this.valueTypeName = type.getValueType() != null ? this.getLocalName(type.getValueType()) : null;
        this.queryTypeName = type.getTypeCategory().isSubCategoryOf(TypeCategory.SIMPLE) ? null : (this.isVisible(type) ? classModel.getPrefix() + type.getSimpleName() : type.getPackageName() + "." + classModel.getPrefix() + type.getSimpleName());
    }

    private boolean isVisible(TypeModel type) {
        return this.classModel.getPackageName().equals(type.getPackageName()) || type.getPackageName().equals("java.lang");
    }

    private String getLocalName(TypeModel type) {
        return this.isVisible(type) ? type.getLocalName() : type.getName();
    }

    @Override
    public int compareTo(FieldModel o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public FieldModel createCopy(ClassModel model) {
        return new FieldModel(model, this.name, this.type, this.docs);
    }

    public boolean equals(Object o) {
        return o instanceof FieldModel && this.name.equals(((FieldModel)o).name);
    }

    public String getDocString() {
        return this.docs;
    }

    public TypeCategory getTypeCategory() {
        return this.type.getTypeCategory();
    }

    public String getKeyTypeName() {
        return this.keyTypeName;
    }

    public String getValueTypeName() {
        return this.valueTypeName;
    }

    public String getName() {
        return this.name;
    }

    public String getEscapedName() {
        return this.escapedName;
    }

    public String getQueryTypeName() {
        return this.queryTypeName;
    }

    public String getSimpleTypeName() {
        return this.type.getSimpleName();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypePackage() {
        return this.type.getPackageName();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.type.getName() + " " + this.name;
    }
}

