/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.annotations.QueryTransient;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.codegen.ClassModel;
import com.mysema.query.codegen.FieldModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import com.mysema.query.codegen.TypeModelFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.jcip.annotations.Immutable;

@Immutable
public class ClassModelFactory {
    private final TypeModelFactory typeModelFactory;
    private final Class<? extends Annotation> skipAnn;

    public ClassModelFactory(TypeModelFactory typeModelFactory, Class<? extends Annotation> skipAnn) {
        this.typeModelFactory = typeModelFactory;
        this.skipAnn = skipAnn;
    }

    public ClassModelFactory(TypeModelFactory typeModelFactory) {
        this(typeModelFactory, QueryTransient.class);
    }

    public ClassModel create(Class<?> key, String prefix) {
        ClassModel classModel = new ClassModel(prefix, key.getSuperclass().getName(), key.getPackage().getName(), key.getName(), key.getSimpleName());
        for (Field f : key.getDeclaredFields()) {
            if (!this.isValidField(f)) continue;
            TypeModel typeModel = this.typeModelFactory.create(f.getType(), f.getGenericType());
            if (f.getAnnotation(QueryType.class) != null) {
                TypeCategory typeCategory = TypeCategory.get(f.getAnnotation(QueryType.class).value());
                if (typeCategory == null) continue;
                typeModel = typeModel.as(typeCategory);
            }
            classModel.addField(new FieldModel(classModel, f.getName(), typeModel, f.getName()));
        }
        return classModel;
    }

    protected boolean isValidField(Field field) {
        return field.getAnnotation(this.skipAnn) == null && !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers());
    }
}

