/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.alias;

import com.mysema.query.alias.AliasFactory;
import com.mysema.query.alias.ManagedObject;
import com.mysema.query.alias.PropertyAccessInvocationHandler;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.util.FactoryMap;
import com.mysema.query.util.NotEmpty;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

class SimpleAliasFactory
implements AliasFactory {
    private final ThreadLocal<Expr<?>> current = new ThreadLocal();
    private FactoryMap<PEntity<?>> pathCache = new FactoryMap<PEntity<?>>(){

        public <A> PEntity<A> create(Class<A> cl, @NotEmpty String var) {
            return new PEntity<A>(cl, cl.getSimpleName(), PathMetadata.forVariable(var));
        }
    };
    private FactoryMap<ManagedObject> proxyCache = new FactoryMap<ManagedObject>(){

        public ManagedObject create(Class<?> cl, Expr<?> path) {
            return (ManagedObject)SimpleAliasFactory.this.createProxy(cl, path);
        }
    };

    SimpleAliasFactory() {
    }

    @Override
    public <A> A createAliasForProp(Class<A> cl, Object parent, Expr<?> path) {
        A proxy = this.createProxy(cl, path);
        return proxy;
    }

    @Override
    public <A> A createAliasForVar(Class<A> cl, String var) {
        Expr path = this.pathCache.get(cl, var);
        ManagedObject proxy = this.proxyCache.get(cl, path);
        return (A)proxy;
    }

    @Override
    public <A> A createAliasForExpr(Class<A> cl, Expr<? extends A> expr) {
        return (A)this.proxyCache.get(cl, expr);
    }

    private <A> A createProxy(Class<A> cl, Expr<?> path) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(SimpleAliasFactory.class.getClassLoader());
        if (cl.isInterface()) {
            enhancer.setInterfaces(new Class[]{cl, ManagedObject.class});
        } else {
            enhancer.setSuperclass(cl);
            enhancer.setInterfaces(new Class[]{ManagedObject.class});
        }
        PropertyAccessInvocationHandler handler = new PropertyAccessInvocationHandler(path, this);
        enhancer.setCallback((Callback)handler);
        Object rv = enhancer.create();
        return (A)rv;
    }

    @Override
    public <A extends Expr<?>> A getCurrent() {
        return (A)this.current.get();
    }

    @Override
    public <A extends Expr<?>> A getCurrentAndReset() {
        A rv = this.getCurrent();
        this.reset();
        return rv;
    }

    @Override
    public void reset() {
        this.current.set(null);
    }

    @Override
    public void setCurrent(Expr<?> path) {
        this.current.set(path);
    }
}

