/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.mysema.query.CascadingBoolean;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.Expr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class DefaultQueryMetadata
implements QueryMetadata {
    private boolean distinct;
    private final Set<Expr<?>> exprInJoins = new HashSet();
    private final List<Expr<?>> groupBy = new ArrayList();
    private final CascadingBoolean having = new CascadingBoolean();
    private final List<JoinExpression> joins = new ArrayList<JoinExpression>();
    @Nullable
    private QueryModifiers modifiers = new QueryModifiers();
    private final List<OrderSpecifier<?>> orderBy = new ArrayList();
    private final List<Expr<?>> projection = new ArrayList();
    private boolean unique;
    private final CascadingBoolean where = new CascadingBoolean();

    @Override
    public void addFrom(Expr<?> ... o) {
        for (Expr<?> expr : o) {
            if (this.exprInJoins.contains(expr)) continue;
            this.joins.add(new JoinExpression(JoinType.DEFAULT, expr));
            this.exprInJoins.add(expr);
        }
    }

    @Override
    public void addGroupBy(Expr<?> ... o) {
        this.groupBy.addAll(Arrays.asList(o));
    }

    @Override
    public void addHaving(EBoolean ... o) {
        for (EBoolean e : o) {
            this.having.and(e);
        }
    }

    @Override
    public void addJoin(JoinExpression joinExpression) {
        if (!this.exprInJoins.contains(joinExpression.getTarget())) {
            this.joins.add(joinExpression);
            this.exprInJoins.add(joinExpression.getTarget());
        }
    }

    @Override
    public void addJoin(JoinType joinType, Expr<?> expr) {
        if (!this.exprInJoins.contains(expr)) {
            this.joins.add(new JoinExpression(joinType, expr));
            this.exprInJoins.add(expr);
        }
    }

    @Override
    public void addJoinCondition(EBoolean o) {
        if (!this.joins.isEmpty()) {
            this.joins.get(this.joins.size() - 1).setCondition(o);
        }
    }

    @Override
    public void addOrderBy(OrderSpecifier<?> ... o) {
        this.orderBy.addAll(Arrays.asList(o));
    }

    @Override
    public void addProjection(Expr<?> ... o) {
        this.projection.addAll(Arrays.asList(o));
    }

    @Override
    public void addWhere(EBoolean ... o) {
        for (EBoolean e : o) {
            this.where.and(e);
        }
    }

    @Override
    public List<? extends Expr<?>> getGroupBy() {
        return Collections.unmodifiableList(this.groupBy);
    }

    @Override
    public EBoolean getHaving() {
        return this.having.create();
    }

    @Override
    public List<JoinExpression> getJoins() {
        return Collections.unmodifiableList(this.joins);
    }

    @Override
    @Nullable
    public QueryModifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public List<OrderSpecifier<?>> getOrderBy() {
        return Collections.unmodifiableList(this.orderBy);
    }

    @Override
    public List<? extends Expr<?>> getProjection() {
        return Collections.unmodifiableList(this.projection);
    }

    @Override
    public EBoolean getWhere() {
        return this.where.create();
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public void setLimit(Long limit) {
        this.modifiers = this.modifiers == null || this.modifiers.getOffset() == null ? QueryModifiers.limit(limit) : new QueryModifiers(limit, this.modifiers.getOffset());
    }

    @Override
    public void setModifiers(@Nullable QueryModifiers restriction) {
        this.modifiers = restriction;
    }

    @Override
    public void setOffset(Long offset) {
        this.modifiers = this.modifiers == null || this.modifiers.getLimit() == null ? QueryModifiers.offset(offset) : new QueryModifiers(this.modifiers.getLimit(), offset);
    }

    @Override
    public void setUnique(boolean unique) {
        this.unique = unique;
    }
}

