/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.EString;
import com.mysema.query.types.expr.Expr;

public class EStringConst
extends EString
implements Constant<String> {
    private final String constant;
    private volatile ENumber<Long> length;
    private volatile EString lower;
    private volatile EString trim;
    private volatile EString upper;

    EStringConst(String constant) {
        this.constant = constant;
    }

    @Override
    public EString append(String s) {
        return EString.create(this.constant + s);
    }

    @Override
    public EString concat(String s) {
        return this.append(s);
    }

    @Override
    public EBoolean eq(String s) {
        return EBoolean.create(this.constant.equals(s));
    }

    public boolean equals(Object o) {
        return o instanceof Constant ? ((Constant)o).getConstant().equals(this.constant) : false;
    }

    @Override
    public EBoolean equalsIgnoreCase(String str) {
        return EBoolean.create(this.constant.equalsIgnoreCase(str));
    }

    @Override
    public String getConstant() {
        return this.constant;
    }

    @Override
    public int hashCode() {
        return this.constant.hashCode();
    }

    @Override
    public EBoolean isEmpty() {
        return EBoolean.create(this.constant.isEmpty());
    }

    @Override
    public EBoolean isNotEmpty() {
        return EBoolean.create(!this.constant.isEmpty());
    }

    @Override
    public ENumber<Long> length() {
        if (this.length == null) {
            this.length = ENumber.create(Long.valueOf(this.constant.length()));
        }
        return this.length;
    }

    @Override
    public EString lower() {
        if (this.lower == null) {
            this.lower = EString.create(this.constant.toLowerCase());
        }
        return this.lower;
    }

    @Override
    public EBoolean ne(String s) {
        return EBoolean.create(!this.constant.equals(s));
    }

    @Override
    public EString prepend(String s) {
        return EString.create(s + this.constant);
    }

    @Override
    public EString substring(int beginIndex) {
        return EString.create(this.constant.substring(beginIndex));
    }

    @Override
    public EString substring(int beginIndex, int endIndex) {
        return EString.create(this.constant.substring(beginIndex, endIndex));
    }

    @Override
    public EString toLowerCase() {
        return this.lower();
    }

    @Override
    public EString toUpperCase() {
        return this.upper();
    }

    @Override
    public EString trim() {
        if (this.trim == null) {
            this.trim = EString.create(this.constant.trim());
        }
        return this.trim;
    }

    @Override
    public EString upper() {
        if (this.upper == null) {
            this.upper = EString.create(this.constant.toUpperCase());
        }
        return this.upper;
    }

    @Override
    public Expr<String[]> split(String regex) {
        return Expr.create(this.constant.split(regex));
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }
}

