/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.commons.lang.Assert;
import com.mysema.query.annotations.Optional;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EComparable;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.EStringConst;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.OComparable;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.OSimple;
import com.mysema.query.types.operation.OString;
import com.mysema.query.types.operation.Ops;

public abstract class EString
extends EComparable<String> {
    private volatile ENumber<Long> length;
    private volatile EString lower;
    private volatile EString trim;
    private volatile EString upper;

    public static final EString create(String str) {
        return new EStringConst((String)Assert.notNull((Object)str));
    }

    public EString() {
        super(String.class);
    }

    public final EString append(Expr<String> str) {
        return OString.create(Ops.CONCAT, this, str);
    }

    public EString append(String str) {
        return this.append(EString.create(str));
    }

    public Expr<Character> charAt(Expr<Integer> i) {
        return OComparable.create(Character.class, Ops.CHAR_AT, this, i);
    }

    public Expr<Character> charAt(int i) {
        return this.charAt(ENumber.create(i));
    }

    public EString concat(Expr<String> str) {
        return this.append(str);
    }

    public EString concat(String str) {
        return this.append(str);
    }

    public EBoolean contains(Expr<String> str) {
        return OBoolean.create(Ops.STRING_CONTAINS, this, str);
    }

    public EBoolean contains(String str) {
        return this.contains(EString.create(str));
    }

    public EBoolean endsWith(Expr<String> str) {
        return OBoolean.create(Ops.ENDS_WITH, this, str);
    }

    public EBoolean endsWith(Expr<String> str, boolean caseSensitive) {
        if (caseSensitive) {
            return this.endsWith(str);
        }
        return OBoolean.create(Ops.ENDS_WITH_IC, this, str);
    }

    public EBoolean endsWith(String str) {
        return this.endsWith(EString.create(str));
    }

    public EBoolean endsWith(String str, boolean caseSensitive) {
        return this.endsWith(EString.create(str), caseSensitive);
    }

    public EBoolean equalsIgnoreCase(Expr<String> str) {
        return OBoolean.create(Ops.EQ_IGNORE_CASE, this, str);
    }

    public EBoolean equalsIgnoreCase(String str) {
        return this.equalsIgnoreCase(EString.create(str));
    }

    public ENumber<Integer> indexOf(Expr<String> str) {
        return ONumber.create(Integer.class, Ops.INDEX_OF, this, str);
    }

    public ENumber<Integer> indexOf(String str) {
        return this.indexOf(EString.create(str));
    }

    public ENumber<Integer> indexOf(String str, int i) {
        return ONumber.create(Integer.class, Ops.INDEX_OF_2ARGS, this, EString.create(str), ENumber.create(i));
    }

    public EBoolean isEmpty() {
        return OBoolean.create(Ops.STRING_IS_EMPTY, this);
    }

    public EBoolean isNotEmpty() {
        return this.isEmpty().not();
    }

    @Optional
    public ENumber<Integer> lastIndex(String right, int third) {
        return ONumber.create(Integer.class, Ops.StringOps.LAST_INDEX_2ARGS, this, EString.create(right), ENumber.create(third));
    }

    @Optional
    public ENumber<Integer> lastIndexOf(Expr<String> right) {
        return ONumber.create(Integer.class, Ops.StringOps.LAST_INDEX, this, right);
    }

    @Optional
    public ENumber<Integer> lastIndexOf(String right) {
        return ONumber.create(Integer.class, Ops.StringOps.LAST_INDEX, this, EString.create(right));
    }

    public ENumber<Long> length() {
        if (this.length == null) {
            this.length = ONumber.create(Long.class, Ops.STRING_LENGTH, this);
        }
        return this.length;
    }

    public EString lower() {
        if (this.lower == null) {
            this.lower = OString.create(Ops.LOWER, this);
        }
        return this.lower;
    }

    public EBoolean matches(Expr<String> regex) {
        return OBoolean.create(Ops.MATCHES, this, regex);
    }

    public EBoolean matches(String regex) {
        return this.matches(EString.create(regex));
    }

    public EString prepend(Expr<String> str) {
        return OString.create(Ops.CONCAT, str, this);
    }

    public EString prepend(String str) {
        return this.prepend(EString.create(str));
    }

    @Optional
    public Expr<String[]> split(String regex) {
        return OSimple.create(String[].class, Ops.StringOps.SPLIT, this, EString.create(regex));
    }

    public EBoolean startsWith(Expr<String> str) {
        return OBoolean.create(Ops.STARTS_WITH, this, str);
    }

    public EBoolean startsWith(Expr<String> str, boolean caseSensitive) {
        if (caseSensitive) {
            return this.startsWith(str);
        }
        return OBoolean.create(Ops.STARTS_WITH_IC, this, str);
    }

    public EBoolean startsWith(String str) {
        return this.startsWith(EString.create(str));
    }

    public EBoolean startsWith(String str, boolean caseSensitive) {
        return this.startsWith(EString.create(str), caseSensitive);
    }

    @Override
    public EString stringValue() {
        return this;
    }

    public EString substring(int beginIndex) {
        return OString.create(Ops.SUBSTR_1ARG, this, ENumber.create(beginIndex));
    }

    public EString substring(int beginIndex, int endIndex) {
        return OString.create(Ops.SUBSTR_2ARGS, this, ENumber.create(beginIndex), ENumber.create(endIndex));
    }

    public EString toLowerCase() {
        return this.lower();
    }

    public EString toUpperCase() {
        return this.upper();
    }

    public EString trim() {
        if (this.trim == null) {
            this.trim = OString.create(Ops.TRIM, this);
        }
        return this.trim;
    }

    public EString upper() {
        if (this.upper == null) {
            this.upper = OString.create(Ops.UPPER, this);
        }
        return this.upper;
    }
}

