/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.annotations.Optional;
import com.mysema.query.types.expr.EDateOrTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.ODateTime;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import java.util.Date;

public abstract class EDateTime<D extends Comparable>
extends EDateOrTime<D> {
    private volatile ENumber<Integer> dayOfMonth;
    private volatile ENumber<Integer> month;
    private volatile ENumber<Integer> year;
    private volatile ENumber<Integer> hours;
    private volatile ENumber<Integer> minutes;
    private volatile ENumber<Integer> seconds;

    public EDateTime(Class<? extends D> type) {
        super(type);
    }

    public ENumber<Integer> getDayOfMonth() {
        if (this.dayOfMonth == null) {
            this.dayOfMonth = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_MONTH, this);
        }
        return this.dayOfMonth;
    }

    public ENumber<Integer> getHours() {
        if (this.hours == null) {
            this.hours = ONumber.create(Integer.class, Ops.DateTimeOps.HOUR, this);
        }
        return this.hours;
    }

    public ENumber<Integer> getMinutes() {
        if (this.minutes == null) {
            this.minutes = ONumber.create(Integer.class, Ops.DateTimeOps.MINUTE, this);
        }
        return this.minutes;
    }

    public ENumber<Integer> getMonth() {
        if (this.month == null) {
            this.month = ONumber.create(Integer.class, Ops.DateTimeOps.MONTH, this);
        }
        return this.month;
    }

    public ENumber<Integer> getSeconds() {
        if (this.seconds == null) {
            this.seconds = ONumber.create(Integer.class, Ops.DateTimeOps.SECOND, this);
        }
        return this.seconds;
    }

    public ENumber<Integer> getYear() {
        if (this.year == null) {
            this.year = ONumber.create(Integer.class, Ops.DateTimeOps.YEAR, this);
        }
        return this.year;
    }

    @Optional
    public ENumber<Integer> getDayOfWeek() {
        return ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_WEEK, this);
    }

    @Optional
    public ENumber<Integer> getDayOfYear() {
        return ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_YEAR, this);
    }

    @Optional
    public ENumber<Integer> getWeek() {
        return ONumber.create(Integer.class, Ops.DateTimeOps.WEEK, this);
    }

    public static EDateTime<Date> currentDate() {
        return EDateTime.currentDate(Date.class);
    }

    public static EDateTime<Date> currentTimestamp() {
        return EDateTime.currentTimestamp(Date.class);
    }

    public static <T extends Comparable> EDateTime<T> currentDate(Class<T> cl) {
        return ODateTime.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expr[0]);
    }

    public static <T extends Comparable> EDateTime<T> currentTimestamp(Class<T> cl) {
        return ODateTime.create(cl, Ops.DateTimeOps.CURRENT_TIMESTAMP, new Expr[0]);
    }
}

