/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Expr;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ClassUtils;

public class EConstructor<D>
extends Expr<D> {
    private final List<Expr<?>> args;
    private volatile transient Constructor<D> javaConstructor;

    public EConstructor(Class<D> type, Expr<?> ... args) {
        super(type);
        this.args = Collections.unmodifiableList(Arrays.asList(args));
    }

    public final List<Expr<?>> getArgs() {
        return this.args;
    }

    public final Expr<?> getArg(int index) {
        return this.args.get(index);
    }

    public Constructor<D> getJavaConstructor() {
        if (this.javaConstructor == null) {
            Class type = this.getType();
            List<Expr<?>> args = this.getArgs();
            for (Constructor<?> c : type.getConstructors()) {
                Class ptype;
                if (c.getParameterTypes().length != args.size()) continue;
                boolean match = true;
                for (int i = 0; i < args.size() && match; match &= ptype.isAssignableFrom(args.get(i).getType()), ++i) {
                    ptype = c.getParameterTypes()[i];
                    if (!ptype.isPrimitive()) continue;
                    ptype = ClassUtils.primitiveToWrapper(ptype);
                }
                if (!match) continue;
                this.javaConstructor = c;
                return this.javaConstructor;
            }
            throw new IllegalArgumentException("no suitable constructor found");
        }
        return this.javaConstructor;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }
}

