/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EEntity;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.PCollection;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.util.NotEmpty;
import java.util.Collection;

public class PEntityCollection<D>
extends EEntity<Collection<D>>
implements PCollection<D> {
    private final PathMetadata<?> metadata;
    protected final Class<D> elementType;
    protected final String entityName;
    private EBoolean isnull;
    private EBoolean isnotnull;
    private ENumber<Integer> size;
    private final Path<?> root;
    private EBoolean empty;
    private EBoolean notEmpty;

    public PEntityCollection(Class<D> type, @NotEmpty String entityName, PathMetadata<?> metadata) {
        super(Collection.class);
        this.elementType = (Class)Assert.notNull(type, (String)"type is null");
        this.metadata = (PathMetadata)Assert.notNull(metadata, (String)"metadata is null");
        this.entityName = (String)Assert.notNull((Object)entityName, (String)"entityName is null");
        this.root = metadata.getRoot() != null ? metadata.getRoot() : this;
    }

    public PEntityCollection(Class<D> type, @NotEmpty String entityName, @NotEmpty String var) {
        this(type, entityName, PathMetadata.forVariable(var));
    }

    public PEntityCollection(Class<D> type, @NotEmpty String entityName, Path<?> parent, @NotEmpty String property) {
        this(type, entityName, PathMetadata.forProperty(parent, property));
    }

    @Override
    public EBoolean contains(D child) {
        return OBoolean.create(Ops.IN, ExprConst.create(child), this);
    }

    @Override
    public EBoolean contains(Expr<D> child) {
        return OBoolean.create(Ops.IN, child, this);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public boolean equals(Object o) {
        return o instanceof Path ? ((Path)o).getMetadata().equals(this.metadata) : false;
    }

    @Override
    public Class<D> getElementType() {
        return this.elementType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public EBoolean isEmpty() {
        if (this.empty == null) {
            this.empty = OBoolean.create(Ops.COL_IS_EMPTY, this);
        }
        return this.empty;
    }

    @Override
    public EBoolean isNotEmpty() {
        if (this.notEmpty == null) {
            this.notEmpty = this.isEmpty().not();
        }
        return this.notEmpty;
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }

    @Override
    public ENumber<Integer> size() {
        if (this.size == null) {
            this.size = ONumber.create(Integer.class, Ops.COL_SIZE, this);
        }
        return this.size;
    }
}

