/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EEntity;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.PBoolean;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PComponentCollection;
import com.mysema.query.types.path.PComponentList;
import com.mysema.query.types.path.PComponentMap;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntityCollection;
import com.mysema.query.types.path.PEntityList;
import com.mysema.query.types.path.PEntityMap;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PString;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.util.NotEmpty;

public class PEntity<D>
extends EEntity<D>
implements Path<D> {
    private final String entityName;
    private EBoolean isnull;
    private EBoolean isnotnull;
    private final PathMetadata<?> metadata;
    private final Path<?> root;

    public PEntity(Class<? extends D> type, @NotEmpty String entityName, PathMetadata<?> metadata) {
        super(type);
        this.entityName = entityName;
        this.metadata = metadata;
        this.root = metadata.getRoot() != null ? metadata.getRoot() : this;
    }

    public PEntity(Class<? extends D> type, @NotEmpty String entityName, @NotEmpty String var) {
        this(type, Assert.hasLength((String)entityName), PathMetadata.forVariable(var));
    }

    public PEntity(Class<? extends D> type, @NotEmpty String entityName, Path<?> parent, @NotEmpty String property) {
        this(type, Assert.hasLength((String)entityName), PathMetadata.forProperty(parent, property));
    }

    protected PBoolean _boolean(@NotEmpty String propertyName) {
        return new PBoolean(this, propertyName);
    }

    protected <A extends Comparable<?>> PComparable<A> _comparable(@NotEmpty String propertyName, Class<A> type) {
        return new PComparable<A>(type, this, propertyName);
    }

    protected <A extends Comparable<?>> PDate<A> _date(@NotEmpty String propertyName, Class<A> type) {
        return new PDate<A>(type, PathMetadata.forProperty(this, propertyName));
    }

    protected <A extends Comparable<?>> PDateTime<A> _dateTime(@NotEmpty String propertyName, Class<A> type) {
        return new PDateTime<A>(type, this, propertyName);
    }

    protected <A> PEntity<A> _entity(@NotEmpty String property, @NotEmpty String entityName, Class<A> type) {
        return new PEntity<A>(type, entityName, this, property);
    }

    protected <A> PEntityCollection<A> _entitycol(@NotEmpty String property, Class<A> type, @NotEmpty String entityName) {
        return new PEntityCollection<A>(type, entityName, this, property);
    }

    protected <A> PEntityList<A> _entitylist(@NotEmpty String property, Class<A> type, @NotEmpty String entityName) {
        return new PEntityList<A>(type, entityName, this, property);
    }

    protected <K, V> PEntityMap<K, V> _entitymap(@NotEmpty String property, Class<K> key, Class<V> value, @NotEmpty String entityName) {
        return new PEntityMap<K, V>(key, value, entityName, this, property);
    }

    protected <A extends Number> PNumber<A> _number(@NotEmpty String property, Class<A> type) {
        return new PNumber<A>(type, this, property);
    }

    protected <A> PSimple<A> _simple(@NotEmpty String path, Class<A> type) {
        return new PSimple<A>(type, this, path);
    }

    protected <A> PComponentCollection<A> _simplecol(@NotEmpty String path, Class<A> type) {
        return new PComponentCollection<A>(type, this, path);
    }

    protected <A> PComponentList<A> _simplelist(@NotEmpty String path, Class<A> type) {
        return new PComponentList<A>(type, this, path);
    }

    protected <K, V> PComponentMap<K, V> _simplemap(@NotEmpty String path, Class<K> key, Class<V> value) {
        return new PComponentMap<K, V>(key, value, this, path);
    }

    protected PString _string(@NotEmpty String property) {
        return new PString(this, property);
    }

    protected <A extends Comparable<?>> PTime<A> _time(@NotEmpty String propertyName, Class<A> type) {
        return new PTime<A>(type, this, propertyName);
    }

    public boolean equals(Object o) {
        return o instanceof Path ? ((Path)o).getMetadata().equals(this.metadata) : false;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public <B extends D> EBoolean instanceOf(Class<B> type) {
        return OBoolean.create(Ops.INSTANCE_OF, this, ExprConst.create(type));
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }
}

