/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EComparable;
import com.mysema.query.types.expr.ENumberConst;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ENumber<D extends Number>
extends EComparable<D> {
    private static ENumber<Double> random;
    private ENumber<D> abs;
    private ENumber<D> sum;
    private ENumber<D> min;
    private ENumber<D> max;
    private ENumber<Double> avg;
    private ENumber<Double> sqrt;
    private ENumber<D> round;
    private ENumber<D> floor;
    private ENumber<D> ceil;

    public static <T extends Number> ENumber<T> create(T val) {
        return new ENumberConst<Number>(val.getClass(), (Number)Assert.notNull(val, (String)"val is null"));
    }

    public static <A extends Number> ENumber<A> max(Expr<A> left, Expr<A> right) {
        return ONumber.create(left.getType(), Ops.MathOps.MAX, left, right);
    }

    public static <A extends Number> ENumber<A> min(Expr<A> left, Expr<A> right) {
        return ONumber.create(left.getType(), Ops.MathOps.MIN, left, right);
    }

    public static ENumber<Double> random() {
        if (random == null) {
            random = ONumber.create(Double.class, Ops.MathOps.RANDOM, new Expr[0]);
        }
        return random;
    }

    public ENumber(Class<? extends D> type) {
        super(type);
    }

    public ENumber<D> abs() {
        if (this.abs == null) {
            this.abs = ONumber.create(this.getType(), Ops.MathOps.ABS, this);
        }
        return this.abs;
    }

    public ENumber<D> add(D right) {
        return ONumber.create(this.getType(), Ops.ADD, this, ENumber.create(right));
    }

    public ENumber<D> add(Expr<D> right) {
        return ONumber.create(this.getType(), Ops.ADD, this, right);
    }

    public ENumber<Double> avg() {
        if (this.avg == null) {
            this.avg = ONumber.create(Double.class, Ops.AggOps.AVG_AGG, this);
        }
        return this.avg;
    }

    public ENumber<Byte> byteValue() {
        return this.castToNum(Byte.class);
    }

    private D cast(Number number) {
        Class type = this.getType();
        if (type.equals(number.getClass())) {
            return (D)number;
        }
        if (Byte.class.equals(type)) {
            return (D)Byte.valueOf(number.byteValue());
        }
        if (Double.class.equals(type)) {
            return (D)Double.valueOf(number.doubleValue());
        }
        if (Float.class.equals(type)) {
            return (D)Float.valueOf(number.floatValue());
        }
        if (Integer.class.equals(type)) {
            return (D)Integer.valueOf(number.intValue());
        }
        if (Long.class.equals(type)) {
            return (D)Long.valueOf(number.longValue());
        }
        if (Short.class.equals(type)) {
            return (D)Short.valueOf(number.shortValue());
        }
        if (BigInteger.class.equals(type)) {
            return (D)new BigInteger(String.valueOf(number.longValue()));
        }
        if (BigDecimal.class.equals(type)) {
            return (D)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Unsupported target type : " + type.getName());
    }

    @Override
    public <A extends Number> ENumber<A> castToNum(Class<A> type) {
        if (type.equals(this.getType())) {
            return this;
        }
        return super.castToNum(type);
    }

    public ENumber<D> ceil() {
        if (this.ceil == null) {
            this.ceil = ONumber.create(this.getType(), Ops.MathOps.CEIL, this);
        }
        return this.ceil;
    }

    public ENumber<Double> div(D right) {
        return ONumber.create(Double.class, Ops.DIV, this, ENumber.create(right));
    }

    public ENumber<Double> div(Expr<D> right) {
        return ONumber.create(Double.class, Ops.DIV, this, right);
    }

    public ENumber<Double> doubleValue() {
        return this.castToNum(Double.class);
    }

    public ENumber<Float> floatValue() {
        return this.castToNum(Float.class);
    }

    public ENumber<D> floor() {
        if (this.floor == null) {
            this.floor = ONumber.create(this.getType(), Ops.MathOps.FLOOR, this);
        }
        return this.floor;
    }

    public final <A extends Number> EBoolean goe(A right) {
        return this.goe(ENumber.create(this.cast(right)));
    }

    public final <A extends Number> EBoolean goe(Expr<A> right) {
        return OBoolean.create(Ops.GOE, this, right);
    }

    public final <A extends Number> EBoolean gt(A right) {
        return this.gt(ENumber.create(this.cast(right)));
    }

    public final <A extends Number> EBoolean gt(Expr<A> right) {
        return OBoolean.create(Ops.GT, this, right);
    }

    public ENumber<Integer> intValue() {
        return this.castToNum(Integer.class);
    }

    public final <A extends Number> EBoolean loe(A right) {
        return this.loe(ENumber.create(this.cast(right)));
    }

    public final <A extends Number> EBoolean loe(Expr<A> right) {
        return OBoolean.create(Ops.LOE, this, right);
    }

    public ENumber<Long> longValue() {
        return this.castToNum(Long.class);
    }

    public final <A extends Number> EBoolean lt(A right) {
        return this.lt(ENumber.create(this.cast(right)));
    }

    public final <A extends Number> EBoolean lt(Expr<A> right) {
        return OBoolean.create(Ops.LT, this, right);
    }

    public ENumber<D> max() {
        if (this.max == null) {
            this.max = ONumber.create(this.getType(), Ops.AggOps.MAX_AGG, this);
        }
        return this.max;
    }

    public ENumber<D> min() {
        if (this.min == null) {
            this.min = ONumber.create(this.getType(), Ops.AggOps.MIN_AGG, this);
        }
        return this.min;
    }

    public ENumber<D> mult(D right) {
        return ONumber.create(this.getType(), Ops.MULT, this, ENumber.create(right));
    }

    public ENumber<D> mult(Expr<D> right) {
        return ONumber.create(this.getType(), Ops.MULT, this, right);
    }

    public ENumber<D> round() {
        if (this.round == null) {
            this.round = ONumber.create(this.getType(), Ops.MathOps.ROUND, this);
        }
        return this.round;
    }

    public ENumber<Short> shortValue() {
        return this.castToNum(Short.class);
    }

    public ENumber<Double> sqrt() {
        if (this.sqrt == null) {
            this.sqrt = ONumber.create(Double.class, Ops.MathOps.SQRT, this);
        }
        return this.sqrt;
    }

    public ENumber<D> sub(D right) {
        return ONumber.create(this.getType(), Ops.SUB, this, ENumber.create(right));
    }

    public ENumber<D> sub(Expr<D> right) {
        return ONumber.create(this.getType(), Ops.SUB, this, right);
    }

    public ENumber<D> sum() {
        if (this.sum == null) {
            this.sum = ONumber.create(this.getType(), Ops.AggOps.SUM_AGG, this);
        }
        return this.sum;
    }
}

