/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EMap;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import java.util.Map;

public abstract class EMapBase<K, V>
extends Expr<Map<K, V>>
implements EMap<K, V> {
    private ENumber<Integer> size;
    private EBoolean empty;

    public EMapBase(Class<? extends Map<K, V>> type) {
        super(type);
    }

    @Override
    public final EBoolean contains(Expr<K> key, Expr<V> value) {
        return this.get(key).eq(value);
    }

    @Override
    public final EBoolean containsKey(Expr<K> key) {
        return OBoolean.create(Ops.CONTAINS_KEY, this, key);
    }

    @Override
    public final EBoolean containsKey(K key) {
        return OBoolean.create(Ops.CONTAINS_KEY, this, ExprConst.create(key));
    }

    @Override
    public final EBoolean containsValue(Expr<V> value) {
        return OBoolean.create(Ops.CONTAINS_VALUE, this, value);
    }

    @Override
    public final EBoolean containsValue(V value) {
        return OBoolean.create(Ops.CONTAINS_VALUE, this, ExprConst.create(value));
    }

    @Override
    public final EBoolean isEmpty() {
        if (this.empty == null) {
            this.empty = OBoolean.create(Ops.MAP_ISEMPTY, this);
        }
        return this.empty;
    }

    @Override
    public final EBoolean isNotEmpty() {
        return this.isEmpty().not();
    }

    @Override
    public final ENumber<Integer> size() {
        if (this.size == null) {
            this.size = ONumber.create(Integer.class, Ops.MAP_SIZE, this);
        }
        return this.size;
    }
}

