/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.annotations.Optional;
import com.mysema.query.types.expr.EComparable;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.ODate;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import java.util.Date;

public abstract class EDate<D extends Comparable>
extends EComparable<D> {
    private ENumber<Integer> dayOfMonth;
    private ENumber<Integer> month;
    private ENumber<Integer> year;

    public EDate(Class<? extends D> type) {
        super(type);
    }

    public ENumber<Integer> getDayOfMonth() {
        if (this.dayOfMonth == null) {
            this.dayOfMonth = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_MONTH, this);
        }
        return this.dayOfMonth;
    }

    public ENumber<Integer> getMonth() {
        if (this.month == null) {
            this.month = ONumber.create(Integer.class, Ops.DateTimeOps.MONTH, this);
        }
        return this.month;
    }

    public ENumber<Integer> getYear() {
        if (this.year == null) {
            this.year = ONumber.create(Integer.class, Ops.DateTimeOps.YEAR, this);
        }
        return this.year;
    }

    @Optional
    public ENumber<Integer> getDayOfWeek() {
        return ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_WEEK, this);
    }

    @Optional
    public ENumber<Integer> getDayOfYear() {
        return ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_YEAR, this);
    }

    @Optional
    public ENumber<Integer> getWeek() {
        return ONumber.create(Integer.class, Ops.DateTimeOps.WEEK, this);
    }

    public static EDate<Date> currentDate() {
        return EDate.currentDate(Date.class);
    }

    public static <T extends Comparable> EDate<T> currentDate(Class<T> cl) {
        return ODate.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expr[0]);
    }
}

