/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ECollection;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import java.util.Collection;

public abstract class ECollectionBase<D>
extends Expr<Collection<D>>
implements ECollection<D> {
    private EBoolean empty;
    private ENumber<Integer> size;

    public ECollectionBase(Class<? extends Collection<D>> type) {
        super(type);
    }

    @Override
    public final EBoolean contains(D child) {
        return this.contains(ExprConst.create(child));
    }

    @Override
    public final EBoolean contains(Expr<D> child) {
        return OBoolean.create(Ops.IN, child, this);
    }

    @Override
    public final EBoolean isEmpty() {
        if (this.empty == null) {
            this.empty = OBoolean.create(Ops.COL_IS_EMPTY, this);
        }
        return this.empty;
    }

    @Override
    public final EBoolean isNotEmpty() {
        return this.isEmpty().not();
    }

    @Override
    public final ENumber<Integer> size() {
        if (this.size == null) {
            this.size = ONumber.create(Integer.class, Ops.COL_SIZE, this);
        }
        return this.size;
    }
}

