/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public enum TypeCategory {
    SIMPLE(null, new String[0]),
    COMPARABLE(SIMPLE, Comparable.class.getName(), Character.class.getName(), "org.joda.time.Partial"),
    BOOLEAN(COMPARABLE, Boolean.class.getName()),
    DATE(COMPARABLE, java.sql.Date.class.getName(), "org.joda.time.LocalDate"),
    DATETIME(COMPARABLE, Date.class.getName(), Timestamp.class.getName(), "org.joda.time.LocalDateTime", "org.joda.time.Instant", "org.joda.time.DateTime", "org.joda.time.DateMidnight"),
    ENTITY(null, new String[0]),
    ENTITYCOLLECTION(null, new String[0]),
    ENTITYLIST(ENTITYCOLLECTION, new String[0]),
    ENTITYMAP(null, new String[0]),
    NUMERIC(COMPARABLE, Long.class.getName(), Integer.class.getName(), Byte.class.getName(), Double.class.getName(), Float.class.getName(), Short.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName()),
    SIMPLECOLLECTION(null, new String[0]),
    SIMPLELIST(SIMPLECOLLECTION, new String[0]),
    SIMPLEMAP(null, new String[0]),
    STRING(COMPARABLE, String.class.getName()),
    TIME(COMPARABLE, Time.class.getName(), "org.joda.time.LocalTime");

    @Nullable
    private final TypeCategory superType;
    private final Set<String> types;

    private TypeCategory(TypeCategory superType, String ... types) {
        this.superType = superType;
        this.types = new HashSet<String>(types.length);
        for (String type : types) {
            this.types.add(type);
        }
    }

    @Nullable
    public TypeCategory getSuperType() {
        return this.superType;
    }

    public boolean supports(Class<?> cl) {
        return this.supports(cl.getName());
    }

    public boolean supports(String className) {
        return this.types.contains(className);
    }

    public boolean isSubCategoryOf(TypeCategory ancestor) {
        if (this == ancestor) {
            return true;
        }
        if (this.superType == null) {
            return false;
        }
        return this.superType == ancestor || this.superType.isSubCategoryOf(ancestor);
    }

    public static TypeCategory get(String className) {
        for (TypeCategory category : TypeCategory.values()) {
            if (!category.supports(className)) continue;
            return category;
        }
        return SIMPLE;
    }
}

