/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.ClassModelFactory;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.FieldModel;
import com.mysema.query.codegen.TypeCategory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.MapUtils;
import org.apache.commons.lang.StringUtils;

public final class ClassModel
implements Comparable<ClassModel> {
    public static final String DEFAULT_PREFIX = "Q";
    private final Collection<ConstructorModel> constructors = new HashSet<ConstructorModel>();
    private int escapeSuffix = 1;
    private final String simpleName;
    private final String name;
    private final String packageName;
    private final String localName;
    private final String prefix;
    @Nullable
    private final String superType;
    private final Map<TypeCategory, Collection<FieldModel>> typeToFields = MapUtils.lazyMap(new HashMap(), (Factory)new Factory<Collection<FieldModel>>(){

        public Collection<FieldModel> create() {
            return new HashSet<FieldModel>();
        }
    });
    private String uncapSimpleName;
    private final ClassModelFactory factory;

    public ClassModel(ClassModelFactory factory, String prefix, @Nullable String superType, String packageName, String name, String simpleName) {
        this.factory = (ClassModelFactory)Assert.notNull((Object)factory);
        this.prefix = (String)Assert.notNull((Object)prefix);
        this.superType = superType;
        this.packageName = (String)Assert.notNull((Object)packageName);
        this.name = (String)Assert.notNull((Object)name);
        this.simpleName = (String)Assert.notNull((Object)simpleName);
        this.uncapSimpleName = StringUtils.uncapitalize((String)simpleName);
        this.localName = name.substring(packageName.length() + 1);
    }

    public void addConstructor(ConstructorModel co) {
        this.constructors.add(co);
    }

    public void addField(FieldModel field) {
        this.validateField(field);
        Collection<FieldModel> fields = this.typeToFields.get((Object)field.getTypeCategory());
        fields.add(field);
    }

    public void addSupertypeFields(Map<String, ClassModel> entityTypes, Map<String, ClassModel> supertypes) {
        String stype = this.getSupertypeName();
        Class<?> superClass = ClassModel.safeClassForName(stype);
        if (entityTypes.containsKey(stype) || supertypes.containsKey(stype)) {
            while (true) {
                ClassModel sdecl;
                if (entityTypes.containsKey(stype)) {
                    sdecl = entityTypes.get(stype);
                } else if (supertypes.containsKey(stype)) {
                    sdecl = supertypes.get(stype);
                } else {
                    return;
                }
                this.include(sdecl);
                stype = sdecl.getSupertypeName();
            }
        }
        if (superClass != null && !superClass.equals(Object.class)) {
            ClassModel type = this.factory.create(superClass, this.prefix);
            this.include(type);
        }
    }

    @Override
    public int compareTo(ClassModel o) {
        return this.simpleName.compareTo(o.simpleName);
    }

    public boolean equals(Object o) {
        return o instanceof ClassModel && this.simpleName.equals(((ClassModel)o).simpleName);
    }

    public Collection<FieldModel> getBooleanFields() {
        return this.typeToFields.get((Object)TypeCategory.BOOLEAN);
    }

    public Collection<FieldModel> getComparableFields() {
        return this.typeToFields.get((Object)TypeCategory.COMPARABLE);
    }

    public Collection<ConstructorModel> getConstructors() {
        return this.constructors;
    }

    public Collection<FieldModel> getDateFields() {
        return this.typeToFields.get((Object)TypeCategory.DATE);
    }

    public Collection<FieldModel> getDateTimeFields() {
        return this.typeToFields.get((Object)TypeCategory.DATETIME);
    }

    public Collection<FieldModel> getEntityCollections() {
        return this.typeToFields.get((Object)TypeCategory.ENTITYCOLLECTION);
    }

    public Collection<FieldModel> getEntityFields() {
        return this.typeToFields.get((Object)TypeCategory.ENTITY);
    }

    public Collection<FieldModel> getEntityLists() {
        return this.typeToFields.get((Object)TypeCategory.ENTITYLIST);
    }

    public Collection<FieldModel> getEntityMaps() {
        return this.typeToFields.get((Object)TypeCategory.ENTITYMAP);
    }

    public String getName() {
        return this.name;
    }

    public Collection<FieldModel> getNumericFields() {
        return this.typeToFields.get((Object)TypeCategory.NUMERIC);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Collection<FieldModel> getSimpleCollections() {
        return this.typeToFields.get((Object)TypeCategory.SIMPLECOLLECTION);
    }

    public Collection<FieldModel> getSimpleFields() {
        return this.typeToFields.get((Object)TypeCategory.SIMPLE);
    }

    public Collection<FieldModel> getSimpleLists() {
        return this.typeToFields.get((Object)TypeCategory.SIMPLELIST);
    }

    public Collection<FieldModel> getSimpleMaps() {
        return this.typeToFields.get((Object)TypeCategory.SIMPLEMAP);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Collection<FieldModel> getStringFields() {
        return this.typeToFields.get((Object)TypeCategory.STRING);
    }

    public String getSupertypeName() {
        return this.superType;
    }

    public Collection<FieldModel> getTimeFields() {
        return this.typeToFields.get((Object)TypeCategory.TIME);
    }

    public String getUncapSimpleName() {
        return this.uncapSimpleName;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void include(ClassModel clazz) {
        for (TypeCategory category : TypeCategory.values()) {
            Collection<FieldModel> source = clazz.typeToFields.get((Object)category);
            if (source.isEmpty()) continue;
            Collection<FieldModel> target = this.typeToFields.get((Object)category);
            for (FieldModel field : source) {
                target.add(this.validateField(field.createCopy(this)));
            }
        }
    }

    @Nullable
    private static Class<?> safeClassForName(String stype) {
        try {
            return stype != null ? Class.forName(stype) : null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private FieldModel validateField(FieldModel field) {
        if (field.getName().equals(this.uncapSimpleName)) {
            this.uncapSimpleName = StringUtils.uncapitalize((String)this.simpleName) + this.escapeSuffix++;
        }
        return field;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

