/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.codegen.ClassModel;
import com.mysema.query.codegen.ClassModelFactory;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.TypeModelFactory;
import com.mysema.query.util.FileUtils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.List;

public abstract class AbstractSerializer
implements Serializer {
    @Override
    public void serialize(String targetFolder, String prefix, List<Class<? extends Annotation>> entityAnnotations, Class<?> ... types) {
        TypeModelFactory typeModelFactory = new TypeModelFactory(entityAnnotations);
        ClassModelFactory factory = new ClassModelFactory(typeModelFactory);
        for (Class<?> type : types) {
            try {
                ClassModel model = factory.create(type, prefix);
                String packageName = model.getPackageName();
                String path = packageName.replace('.', File.separatorChar) + File.separator + model.getPrefix() + type.getSimpleName() + ".java";
                this.serialize(model, FileUtils.writerFor(new File(targetFolder, path)));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

