/*
 * Copyright (c) 2009 Mysema Ltd.
 * All rights reserved.
 * 
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.Ops;


/**
 * EBoolean represents boolean expressions
 * 
 * @author tiwe
 * @see java.lang.Boolean
 * 
 */
public abstract class EBoolean extends EComparable<Boolean> {
    
    private EBoolean not;

    public EBoolean() {
        super(Boolean.class);
    }

    /**
     * Create an intersection of this and the given expression 
     * 
     * @param right right hand side of the union
     * @return this && right
     */
    public final EBoolean and(EBoolean right) {
        return OBoolean.create(Ops.AND, this, right);
    }

    /**
     * Create a negation of this boolean expression
     * 
     * @return !this
     */
    public EBoolean not() {
        if (not == null){
            not = OBoolean.create(Ops.NOT, this);
        }            
        return not;
    }

    /**
     * Create a union of this and the given expression
     * 
     * @param right right hand side of the union
     * @return this || right
     */
    public final EBoolean or(EBoolean right) {
        return OBoolean.create(Ops.OR, this, right);
    }
    
    public static final EBoolean create(boolean b){
        return b ? EBooleanConst.TRUE : EBooleanConst.FALSE;
    }
}