/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.codegen.Evaluator;
import com.mysema.codegen.EvaluatorFactory;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.collections.ColQuerySerializer;
import com.mysema.query.collections.ColQueryTemplates;
import com.mysema.query.support.CollectionAnyVisitor;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.ParamNotSetException;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.Visitor;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.ClassUtils;

@Immutable
public class DefaultEvaluatorFactory {
    private final EvaluatorFactory factory;
    private final ColQueryTemplates templates;

    public DefaultEvaluatorFactory(ColQueryTemplates templates) {
        this(templates, (URLClassLoader)DefaultEvaluatorFactory.class.getClassLoader(), ToolProvider.getSystemJavaCompiler());
    }

    public DefaultEvaluatorFactory(ColQueryTemplates templates, URLClassLoader classLoader, JavaCompiler compiler) {
        this.templates = templates;
        this.factory = new EvaluatorFactory(classLoader, compiler);
    }

    public <T> Evaluator<T> create(QueryMetadata metadata, List<? extends Expression<?>> sources, Expression<T> projection) {
        int i;
        ColQuerySerializer serializer = new ColQuerySerializer(this.templates);
        serializer.handle(projection);
        Map constantToLabel = serializer.getConstantToLabel();
        Map<String, Object> constants = this.getConstants(metadata, constantToLabel);
        Class[] types = new Class[sources.size()];
        String[] names = new String[sources.size()];
        for (i = 0; i < sources.size(); ++i) {
            types[i] = sources.get(i).getType();
            names[i] = sources.get(i).toString();
        }
        for (i = 0; i < types.length; ++i) {
            if (ClassUtils.wrapperToPrimitive((Class)types[i]) == null) continue;
            types[i] = ClassUtils.wrapperToPrimitive((Class)types[i]);
        }
        String javaSource = serializer.toString();
        if (projection instanceof FactoryExpression) {
            javaSource = "(" + com.mysema.codegen.support.ClassUtils.getName((Class)projection.getType()) + ")(" + javaSource + ")";
        }
        return this.factory.createEvaluator("return " + javaSource + ";", projection.getType(), names, types, constants);
    }

    public <T> Evaluator<List<T>> createEvaluator(QueryMetadata metadata, Expression<? extends T> source, Predicate filter) {
        String typeName = com.mysema.codegen.support.ClassUtils.getName((Class)source.getType());
        ColQuerySerializer ser = new ColQuerySerializer(this.templates);
        ser.append(new String[]{"java.util.List<" + typeName + "> rv = new java.util.ArrayList<" + typeName + ">();\n"});
        ser.append(new String[]{"for (" + typeName + " " + source + " : " + source + "_){\n"});
        ((ColQuerySerializer)((ColQuerySerializer)ser.append(new String[]{"    if ("})).handle((Expression)filter)).append(new String[]{"){\n"});
        ser.append(new String[]{"        rv.add(" + source + ");\n"});
        ser.append(new String[]{"    }\n"});
        ser.append(new String[]{"}\n"});
        ser.append(new String[]{"return rv;"});
        Map constantToLabel = ser.getConstantToLabel();
        Map<String, Object> constants = this.getConstants(metadata, constantToLabel);
        ClassType sourceType = new ClassType(TypeCategory.SIMPLE, source.getType(), new Type[0]);
        ClassType sourceListType = new ClassType(TypeCategory.SIMPLE, Iterable.class, new Type[]{sourceType});
        return this.factory.createEvaluator(ser.toString(), sourceListType, new String[]{source + "_"}, new Type[]{sourceListType}, new Class[]{Iterable.class}, constants);
    }

    public Evaluator<List<Object[]>> createEvaluator(QueryMetadata metadata, List<JoinExpression> joins, @Nullable Predicate filter) {
        ArrayList<String> sourceNames = new ArrayList<String>();
        ArrayList<SimpleType> sourceTypes = new ArrayList<SimpleType>();
        ArrayList<Class<Iterable>> sourceClasses = new ArrayList<Class<Iterable>>();
        StringBuilder vars = new StringBuilder();
        ColQuerySerializer ser = new ColQuerySerializer(this.templates);
        ser.append(new String[]{"java.util.List<Object[]> rv = new java.util.ArrayList<Object[]>();\n"});
        ArrayList<String> anyJoinMatchers = new ArrayList<String>();
        for (JoinExpression join : joins) {
            Expression target = join.getTarget();
            String typeName = com.mysema.codegen.support.ClassUtils.getName((Class)target.getType());
            if (vars.length() > 0) {
                vars.append(",");
            }
            if (join.getType() == JoinType.DEFAULT) {
                ser.append(new String[]{"for (" + typeName + " " + target + " : " + target + "_){\n"});
                vars.append(target);
                sourceNames.add(target + "_");
                sourceTypes.add(new SimpleType((Type)Types.ITERABLE, new Type[]{new ClassType(TypeCategory.SIMPLE, target.getType(), new Type[0])}));
                sourceClasses.add(Iterable.class);
                continue;
            }
            if (join.getType() == JoinType.INNERJOIN) {
                boolean colAnyJoin;
                Operation alias = (Operation)join.getTarget();
                boolean bl = colAnyJoin = join.getCondition() != null && join.getCondition().toString().equals("any");
                if (colAnyJoin) {
                    String matcher = alias.getArg(1).toString() + "_matched";
                    ser.append(new String[]{"boolean " + matcher + " = false;\n"});
                    anyJoinMatchers.add(matcher);
                }
                ser.append(new String[]{"for ( " + typeName + " " + alias.getArg(1) + " : "});
                if (colAnyJoin) {
                    CollectionAnyVisitor.Context context = new CollectionAnyVisitor.Context();
                    Expression replacement = (Expression)alias.getArg(0).accept((Visitor)CollectionAnyVisitor.DEFAULT, (Object)context);
                    ser.handle(replacement);
                } else {
                    ser.handle(alias.getArg(0));
                }
                if (alias.getArg(0).getType().equals(Map.class)) {
                    ser.append(new String[]{".values()"});
                }
                ser.append(new String[]{"){\n"});
                vars.append(alias.getArg(1));
                continue;
            }
            throw new IllegalArgumentException("Illegal join expression " + join);
        }
        if (filter != null) {
            ser.append(new String[]{"if ("});
            for (String matcher : anyJoinMatchers) {
                ser.append(new String[]{"!" + matcher + " && "});
            }
            ((ColQuerySerializer)ser.handle((Expression)filter)).append(new String[]{"){\n"});
            for (String matcher : anyJoinMatchers) {
                ser.append(new String[]{"    " + matcher + " = true;\n"});
            }
            ser.append(new String[]{"    rv.add(new Object[]{" + vars + "});\n"});
            ser.append(new String[]{"}\n"});
        } else {
            ser.append(new String[]{"rv.add(new Object[]{" + vars + "});\n"});
        }
        for (int i = 0; i < joins.size(); ++i) {
            ser.append(new String[]{"}\n"});
        }
        ser.append(new String[]{"return rv;"});
        Map constantToLabel = ser.getConstantToLabel();
        Map<String, Object> constants = this.getConstants(metadata, constantToLabel);
        ClassType projectionType = new ClassType(TypeCategory.LIST, List.class, new Type[]{Types.OBJECTS});
        return this.factory.createEvaluator(ser.toString(), projectionType, sourceNames.toArray(new String[sourceNames.size()]), sourceTypes.toArray(new Type[sourceTypes.size()]), sourceClasses.toArray(new Class[sourceClasses.size()]), constants);
    }

    private Map<String, Object> getConstants(QueryMetadata metadata, Map<Object, String> constantToLabel) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        for (Map.Entry<Object, String> entry : constantToLabel.entrySet()) {
            if (entry.getKey() instanceof ParamExpression) {
                Object value = metadata.getParams().get(entry.getKey());
                if (value == null) {
                    throw new ParamNotSetException((ParamExpression)entry.getKey());
                }
                constants.put(entry.getValue(), value);
                continue;
            }
            constants.put(entry.getValue(), entry.getKey());
        }
        return constants;
    }
}

