/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.util;

import com.mysema.commons.lang.Assert;
import com.mysema.query.QueryModifiers;
import java.util.Iterator;

public class LimitingIterator<E>
implements Iterator<E> {
    private long counter;
    private final long limit;
    private final Iterator<E> original;

    public static <T> Iterator<T> create(Iterator<T> iterator, QueryModifiers modifiers) {
        if (modifiers.isRestricting()) {
            if (modifiers.getOffset() != null) {
                int counter = 0;
                while (iterator.hasNext() && (long)counter < modifiers.getOffset()) {
                    ++counter;
                    iterator.next();
                }
            }
            if (modifiers.getLimit() != null) {
                iterator = new LimitingIterator<T>(iterator, modifiers.getLimit());
            }
        }
        return iterator;
    }

    LimitingIterator(Iterator<E> iterator, long limit) {
        this.original = (Iterator)Assert.notNull(iterator, (String)"iterator");
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        return this.original.hasNext() && this.counter < this.limit;
    }

    @Override
    public E next() {
        ++this.counter;
        return this.original.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

