/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections.impl;

import com.mysema.query.collections.ColQueryTemplates;
import com.mysema.query.serialization.SerializerBase;
import com.mysema.query.types.Template;
import com.mysema.query.types.Templates;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.Operator;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathType;
import com.mysema.query.types.query.SubQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class ColQuerySerializer
extends SerializerBase<ColQuerySerializer> {
    private static final List<PathType> nonGeneric = Arrays.asList(PathType.ARRAYVALUE, PathType.ARRAYVALUE_CONSTANT, PathType.PROPERTY, PathType.VARIABLE);

    public ColQuerySerializer(ColQueryTemplates patterns) {
        super((Templates)patterns);
    }

    public void visit(Path<?> path) {
        PathType pathType = path.getMetadata().getPathType();
        if (pathType == PathType.PROPERTY) {
            String prefix = "get";
            if (path.getType() != null && path.getType().equals(Boolean.class)) {
                prefix = "is";
            }
            this.handle((Expr)path.getMetadata().getParent());
            ((ColQuerySerializer)this.append(new String[]{"."})).append(new String[]{prefix});
            this.append(new String[]{StringUtils.capitalize((String)path.getMetadata().getExpression().toString()) + "()"});
        } else {
            if (!nonGeneric.contains(pathType)) {
                ((ColQuerySerializer)((ColQuerySerializer)this.append(new String[]{"(("})).append(new String[]{path.getType().getName()})).append(new String[]{")"});
            }
            ArrayList<Expr> args = new ArrayList<Expr>(2);
            if (path.getMetadata().getParent() != null) {
                args.add((Expr)path.getMetadata().getParent());
            }
            args.add(path.getMetadata().getExpression());
            Template template = this.getTemplate((Operator)pathType);
            for (Template.Element element : template.getElements()) {
                if (element.getStaticText() != null) {
                    this.append(new String[]{element.getStaticText()});
                    continue;
                }
                if (element.isAsString()) {
                    this.append(new String[]{((Expr)args.get(element.getIndex())).toString()});
                    continue;
                }
                this.handle((Expr)args.get(element.getIndex()));
            }
            if (!nonGeneric.contains(pathType)) {
                this.append(new String[]{")"});
            }
        }
    }

    private void visitCast(Operator<?> operator, Expr<?> source, Class<?> targetType) {
        if (Number.class.isAssignableFrom(source.getType()) && !Constant.class.isInstance(source)) {
            ((ColQuerySerializer)((ColQuerySerializer)this.append(new String[]{"new "})).append(new String[]{source.getType().getSimpleName()})).append(new String[]{"("});
            this.handle(source);
            this.append(new String[]{")"});
        } else {
            this.handle(source);
        }
        if (Byte.class.equals(targetType)) {
            this.append(new String[]{".byteValue()"});
        } else if (Double.class.equals(targetType)) {
            this.append(new String[]{".doubleValue()"});
        } else if (Float.class.equals(targetType)) {
            this.append(new String[]{".floatValue()"});
        } else if (Integer.class.equals(targetType)) {
            this.append(new String[]{".intValue()"});
        } else if (Long.class.equals(targetType)) {
            this.append(new String[]{".longValue()"});
        } else if (Short.class.equals(targetType)) {
            this.append(new String[]{".shortValue()"});
        } else if (String.class.equals(targetType)) {
            this.append(new String[]{".toString()"});
        } else {
            throw new IllegalArgumentException("Unsupported cast type " + targetType.getName());
        }
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<Expr<?>> args) {
        if (operator.equals((Object)Ops.STRING_CAST)) {
            this.visitCast(operator, args.get(0), String.class);
        } else if (operator.equals((Object)Ops.NUMCAST)) {
            this.visitCast(operator, args.get(0), (Class)((Constant)args.get(1)).getConstant());
        } else {
            super.visitOperation(type, operator, args);
        }
    }

    public void visit(SubQuery expr) {
        throw new IllegalArgumentException("Not supported");
    }
}

