/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections.impl;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.JoinExpression;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.collections.impl.Evaluator;
import com.mysema.query.collections.impl.EvaluatorFactory;
import com.mysema.query.collections.impl.IteratorFactory;
import com.mysema.query.collections.impl.LimitingIterator;
import com.mysema.query.collections.impl.MultiComparator;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.expr.EArrayConstructor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.Path;
import com.mysema.util.MultiIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.IteratorUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.iterators.FilterIterator;
import org.apache.commons.collections15.iterators.UniqueFilterIterator;

public abstract class AbstractColQuery<Q extends AbstractColQuery<Q>>
extends ProjectableQuery<Q> {
    private boolean arrayProjection = false;
    private final EvaluatorFactory evaluatorFactory;
    private final Map<Expr<?>, Iterable<?>> exprToIt = new HashMap();
    private final IteratorFactory iteratorFactory;

    public AbstractColQuery(QueryMetadata metadata, EvaluatorFactory evaluatorFactory) {
        super(new QueryMixin(metadata));
        this.queryMixin.setSelf((Object)this);
        this.evaluatorFactory = evaluatorFactory;
        this.iteratorFactory = new IteratorFactory(evaluatorFactory);
    }

    private <RT> Iterator<RT> asDistinctIterator(Iterator<RT> rv) {
        if (!this.arrayProjection) {
            return new UniqueFilterIterator(rv);
        }
        return new FilterIterator(rv, new Predicate(){
            private Set<List<Object>> set = new HashSet<List<Object>>();

            public boolean evaluate(Object object) {
                return this.set.add(Arrays.asList((Object[])object));
            }
        });
    }

    public long count() {
        try {
            ArrayList sources = new ArrayList();
            Iterator<?> it = this.queryMixin.getMetadata().getJoins().size() == 1 ? this.handleFromWhereSingleSource(sources) : this.handleFromWhereMultiSource(sources);
            if (this.queryMixin.isDistinct()) {
                this.arrayProjection = true;
                it = this.asDistinctIterator(it);
            }
            long count = 0L;
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            long l = count;
            return l;
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private <RT> Iterator<RT> createIterator(Expr<RT> projection) {
        QueryMetadata md = this.queryMixin.getMetadata();
        ArrayList sources = new ArrayList();
        Iterator<?> it = md.getJoins().size() == 1 ? this.handleFromWhereSingleSource(sources) : this.handleFromWhereMultiSource(sources);
        if (!md.getGroupBy().isEmpty() && md.getHaving() != null) {
            it = this.iteratorFactory.multiArgFilter(it, sources, md.getHaving());
        }
        if (it.hasNext()) {
            if (!md.getOrderBy().isEmpty()) {
                it = this.handleOrderBy(sources, it);
            }
            return this.handleSelect(it, sources, projection);
        }
        return Collections.emptyList().iterator();
    }

    private <RT> Iterator<RT> createPagedIterator(Expr<RT> projection) throws Exception {
        Iterator<RT> iterator = this.createIterator(projection);
        return LimitingIterator.create(iterator, this.queryMixin.getMetadata().getModifiers());
    }

    public <A> Q from(Path<A> entity, Iterable<? extends A> col) {
        this.exprToIt.put(entity.asExpr(), col);
        this.queryMixin.getMetadata().addFrom(new Expr[]{entity.asExpr()});
        return (Q)((Object)this);
    }

    protected EvaluatorFactory getEvaluatorFactory() {
        return this.evaluatorFactory;
    }

    protected Iterator<?> handleFromWhereMultiSource(List<Expr<?>> sources) {
        EBoolean condition = this.queryMixin.getMetadata().getWhere();
        ArrayList joins = new ArrayList(this.queryMixin.getMetadata().getJoins());
        for (JoinExpression join : joins) {
            sources.add(join.getTarget());
        }
        ArrayList iterables = new ArrayList(sources.size());
        for (Expr<?> expr : sources) {
            iterables.add(this.exprToIt.get(expr));
        }
        Object it = new MultiIterator(iterables);
        if (condition != null) {
            it = this.iteratorFactory.multiArgFilter(it, sources, condition);
        }
        return it;
    }

    protected Iterator<?> handleFromWhereSingleSource(List<Expr<?>> sources) {
        EBoolean condition = this.queryMixin.getMetadata().getWhere();
        JoinExpression join = (JoinExpression)this.queryMixin.getMetadata().getJoins().get(0);
        sources.add(join.getTarget());
        Iterator<?[]> it = this.iteratorFactory.toArrayIterator(this.exprToIt.get(join.getTarget()).iterator());
        if (condition != null) {
            it = this.iteratorFactory.multiArgFilter(it, sources, condition);
        }
        return it;
    }

    protected Iterator<?> handleOrderBy(List<Expr<?>> sources, Iterator<?> it) {
        List orderBy = this.queryMixin.getMetadata().getOrderBy();
        Expr[] orderByExpr = new Expr[orderBy.size()];
        boolean[] directions = new boolean[orderBy.size()];
        for (int i = 0; i < orderBy.size(); ++i) {
            orderByExpr[i] = ((OrderSpecifier)orderBy.get(i)).getTarget();
            directions[i] = ((OrderSpecifier)orderBy.get(i)).getOrder() == Order.ASC;
        }
        EArrayConstructor expr = new EArrayConstructor(Object[].class, orderByExpr);
        Evaluator<Object[]> ev = this.evaluatorFactory.create((List<? extends Expr<?>>)sources, expr);
        List itAsList = IteratorUtils.toList(it);
        Collections.sort(itAsList, new MultiComparator(ev, directions));
        it = itAsList.iterator();
        return it;
    }

    protected <RT> Iterator<RT> handleSelect(Iterator<?> it, List<Expr<?>> sources, Expr<RT> projection) {
        Iterator<RT> rv = this.iteratorFactory.transform(it, sources, projection);
        if (this.queryMixin.isDistinct()) {
            rv = this.asDistinctIterator(rv);
        }
        return rv;
    }

    public CloseableIterator<Object[]> iterate(Expr<?>[] args) {
        this.arrayProjection = true;
        EArrayConstructor projection = new EArrayConstructor(Object[].class, args);
        return this.iterate((Expr)projection);
    }

    public <RT> CloseableIterator<RT> iterate(Expr<RT> projection) {
        try {
            this.queryMixin.addToProjection(new Expr[]{projection});
            IteratorAdapter iteratorAdapter = new IteratorAdapter(this.createPagedIterator(projection));
            return iteratorAdapter;
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    public <RT> SearchResults<RT> listResults(Expr<RT> projection) {
        List list;
        QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
        try {
            list = IteratorUtils.toList(this.createIterator(projection));
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        if (list.isEmpty()) {
            this.reset();
            return SearchResults.emptyResults();
        }
        if (!modifiers.isRestricting()) {
            this.reset();
            return new SearchResults(list, modifiers, (long)list.size());
        }
        int start = 0;
        int end = list.size();
        if (modifiers.getOffset() != null) {
            if (modifiers.getOffset() < (long)list.size()) {
                start = modifiers.getOffset().intValue();
            } else {
                this.reset();
                return new SearchResults(Collections.emptyList(), modifiers, (long)list.size());
            }
        }
        if (modifiers.getLimit() != null) {
            end = (int)Math.min((long)start + modifiers.getLimit(), (long)list.size());
        }
        this.reset();
        return new SearchResults(list.subList(start, end), modifiers, (long)list.size());
    }

    private void reset() {
        this.queryMixin.getMetadata().reset();
    }
}

