/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections.impl;

import com.mysema.query.collections.impl.Evaluator;
import com.mysema.query.collections.impl.EvaluatorFactory;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.Expr;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections15.IteratorUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;

@Immutable
public class IteratorFactory {
    private final EvaluatorFactory evaluatorFactory;

    public IteratorFactory(EvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
    }

    public <S> Iterator<S> multiArgFilter(Iterator<S> source, List<Expr<?>> sources, EBoolean condition) {
        Evaluator<Boolean> ev = this.evaluatorFactory.create((List<? extends Expr<?>>)sources, condition);
        return this.multiArgFilter(source, ev);
    }

    private <S> Iterator<S> multiArgFilter(Iterator<S> source, final Evaluator<Boolean> ev) {
        return IteratorUtils.filteredIterator(source, (Predicate)new Predicate<S>(){

            public boolean evaluate(S object) {
                return (Boolean)ev.evaluate((Object[])object);
            }
        });
    }

    public <S, T> Iterator<T> transform(Iterator<S> source, List<Expr<?>> sources, Expr<T> projection) {
        Evaluator<T> ev = this.evaluatorFactory.create(sources, projection);
        return this.transform(source, ev);
    }

    private <S, T> Iterator<T> transform(Iterator<S> source, final Evaluator<T> ev) {
        return IteratorUtils.transformedIterator(source, (Transformer)new Transformer<S, T>(){

            public T transform(S input) {
                return ev.evaluate((Object[])input);
            }
        });
    }

    public <S> Iterator<S> singleArgFilter(Iterator<S> source, final Evaluator<Boolean> ev) {
        return IteratorUtils.filteredIterator(source, (Predicate)new Predicate<S>(){

            public boolean evaluate(S object) {
                return (Boolean)ev.evaluate(object);
            }
        });
    }

    public <S> Iterator<S[]> toArrayIterator(Iterator<S> source) {
        return IteratorUtils.transformedIterator(source, (Transformer)new Transformer<S, S[]>(){

            public S[] transform(S input) {
                return new Object[]{input};
            }
        });
    }
}

