/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.query.serialization.JavaTemplates;
import com.mysema.query.types.operation.Operator;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.PathType;
import java.util.Calendar;
import java.util.Date;

public class ColQueryTemplates
extends JavaTemplates {
    public static final ColQueryTemplates DEFAULT = new ColQueryTemplates();

    protected ColQueryTemplates() {
        String functions = ColQueryTemplates.class.getName();
        this.add(Ops.EQ_OBJECT, "{0}.equals({1})");
        this.add(Ops.NE_OBJECT, "!{0}.equals({1})");
        this.add(Ops.INSTANCE_OF, "{1}.isInstance({0})");
        this.add(Ops.AFTER, "{0}.compareTo({1}) > 0");
        this.add(Ops.BEFORE, "{0}.compareTo({1}) < 0");
        this.add(Ops.AOE, "{0}.compareTo({1}) >= 0");
        this.add(Ops.BOE, "{0}.compareTo({1}) <= 0");
        this.add(Ops.BETWEEN, functions + ".between({0},{1},{2})");
        this.add(Ops.STRING_CAST, "String.valueOf({0})");
        this.add(Ops.DateTimeOps.YEAR, functions + ".getYear({0})");
        this.add(Ops.DateTimeOps.YEAR_MONTH, functions + ".getYearMonth({0})");
        this.add(Ops.DateTimeOps.MONTH, functions + ".getMonth({0})");
        this.add(Ops.DateTimeOps.WEEK, functions + ".getWeek({0})");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, functions + ".getDayOfWeek({0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, functions + ".getDayOfMonth({0})");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, functions + ".getDayOfYear({0})");
        this.add(Ops.DateTimeOps.HOUR, functions + ".getHour({0})");
        this.add(Ops.DateTimeOps.MINUTE, functions + ".getMinute({0})");
        this.add(Ops.DateTimeOps.SECOND, functions + ".getSecond({0})");
        this.add(Ops.DateTimeOps.MILLISECOND, functions + ".getMilliSecond({0})");
        this.add(Ops.LIKE, functions + ".like({0},{1})");
        for (PathType type : new PathType[]{PathType.LISTVALUE, PathType.MAPVALUE, PathType.MAPVALUE_CONSTANT}) {
            this.add((Operator)type, "{0}.get({1})");
        }
        this.add((Operator)PathType.LISTVALUE_CONSTANT, "{0}.get({1s})");
        this.add((Operator)PathType.ARRAYVALUE, "{0}[{1}]");
        this.add((Operator)PathType.ARRAYVALUE_CONSTANT, "{0}[{1s}]");
        this.add(Ops.DIV, "(double)({0}/{1})");
    }

    public static boolean like(String str, String like) {
        return str.matches(like.replace("%", ".*").replace('_', '.'));
    }

    public static <A extends Comparable<? super A>> boolean between(A a, A b, A c) {
        return a.compareTo(b) > 0 && a.compareTo(c) < 0;
    }

    public static int getYear(Date date) {
        return ColQueryTemplates.getField(date, 1);
    }

    public static int getYearMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1) * 100 + cal.get(2) + 1;
    }

    public static int getMonth(Date date) {
        return ColQueryTemplates.getField(date, 2) + 1;
    }

    public static int getWeek(Date date) {
        return ColQueryTemplates.getField(date, 3);
    }

    public static int getDayOfMonth(Date date) {
        return ColQueryTemplates.getField(date, 5);
    }

    public static int getDayOfWeek(Date date) {
        return ColQueryTemplates.getField(date, 7);
    }

    public static int getDayOfYear(Date date) {
        return ColQueryTemplates.getField(date, 6);
    }

    public static int getHour(Date date) {
        return ColQueryTemplates.getField(date, 11);
    }

    public static int getMinute(Date date) {
        return ColQueryTemplates.getField(date, 12);
    }

    public static int getSecond(Date date) {
        return ColQueryTemplates.getField(date, 13);
    }

    public static int getMilliSecond(Date date) {
        return ColQueryTemplates.getField(date, 14);
    }

    private static int getField(Date date, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(field);
    }
}

