/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections.impl;

import com.mysema.query.JoinExpression;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.collections.impl.Evaluator;
import com.mysema.query.collections.impl.EvaluatorFactory;
import com.mysema.query.collections.impl.IteratorFactory;
import com.mysema.query.collections.impl.LimitingIterator;
import com.mysema.query.collections.impl.MultiComparator;
import com.mysema.query.support.QueryBaseWithProjection;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.expr.EArrayConstructor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.Path;
import com.mysema.util.MultiIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.IteratorUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.iterators.FilterIterator;
import org.apache.commons.collections15.iterators.UniqueFilterIterator;

public abstract class AbstractColQuery<SubType extends AbstractColQuery<SubType>>
extends QueryBaseWithProjection<SubType> {
    private final EvaluatorFactory evaluatorFactory;
    private final IteratorFactory iteratorFactory;
    private boolean arrayProjection = false;
    private final Map<Expr<?>, Iterable<?>> exprToIt = new HashMap();

    public AbstractColQuery(QueryMetadata metadata, EvaluatorFactory evaluatorFactory) {
        super(metadata);
        this.evaluatorFactory = evaluatorFactory;
        this.iteratorFactory = new IteratorFactory(evaluatorFactory);
    }

    public long count() {
        try {
            ArrayList sources = new ArrayList();
            Iterator<?> it = this.getMetadata().getJoins().size() == 1 ? this.handleFromWhereSingleSource(sources) : this.handleFromWhereMultiSource(sources);
            if (this.getMetadata().isDistinct()) {
                this.arrayProjection = true;
                it = this.asDistinctIterator(it);
            }
            long count = 0L;
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private <RT> Iterator<RT> createIterator(Expr<RT> projection) throws Exception {
        QueryMetadata md = this.getMetadata();
        ArrayList sources = new ArrayList();
        Iterator<?> it = md.getJoins().size() == 1 ? this.handleFromWhereSingleSource(sources) : this.handleFromWhereMultiSource(sources);
        if (!md.getGroupBy().isEmpty() && md.getHaving() != null) {
            it = this.iteratorFactory.multiArgFilter(it, sources, md.getHaving());
        }
        if (it.hasNext()) {
            if (!md.getOrderBy().isEmpty()) {
                it = this.handleOrderBy(sources, it);
            }
            return this.handleSelect(it, sources, projection);
        }
        return Collections.emptyList().iterator();
    }

    private <RT> Iterator<RT> createPagedIterator(Expr<RT> projection) throws Exception {
        Iterator<RT> iterator = this.createIterator(projection);
        return LimitingIterator.create(iterator, this.getMetadata().getModifiers());
    }

    public <A> SubType from(Path<A> entity, Iterable<? extends A> col) {
        this.exprToIt.put(entity.asExpr(), col);
        this.getMetadata().addFrom(new Expr[]{entity.asExpr()});
        return (SubType)((Object)((AbstractColQuery)this._this));
    }

    protected Iterator<?> handleFromWhereMultiSource(List<Expr<?>> sources) throws Exception {
        EBoolean condition = this.getMetadata().getWhere();
        ArrayList joins = new ArrayList(this.getMetadata().getJoins());
        for (JoinExpression join : joins) {
            sources.add(join.getTarget());
        }
        ArrayList iterables = new ArrayList(sources.size());
        for (Expr<?> expr : sources) {
            iterables.add(this.exprToIt.get(expr));
        }
        Iterator<T[]> it = new MultiIterator(iterables);
        if (condition != null) {
            it = this.iteratorFactory.multiArgFilter(it, sources, condition);
        }
        return it;
    }

    protected Iterator<?> handleFromWhereSingleSource(List<Expr<?>> sources) throws Exception {
        EBoolean condition = this.getMetadata().getWhere();
        JoinExpression join = (JoinExpression)this.getMetadata().getJoins().get(0);
        sources.add(join.getTarget());
        Iterator<Object> it = this.exprToIt.get(join.getTarget()).iterator();
        it = this.iteratorFactory.toArrayIterator(this.exprToIt.get(join.getTarget()).iterator());
        if (condition != null) {
            it = this.iteratorFactory.multiArgFilter(it, sources, condition);
        }
        return it;
    }

    protected Iterator<?> handleOrderBy(List<Expr<?>> sources, Iterator<?> it) throws Exception {
        List orderBy = this.getMetadata().getOrderBy();
        Expr[] orderByExpr = new Expr[orderBy.size()];
        boolean[] directions = new boolean[orderBy.size()];
        for (int i = 0; i < orderBy.size(); ++i) {
            orderByExpr[i] = ((OrderSpecifier)orderBy.get(i)).getTarget();
            directions[i] = ((OrderSpecifier)orderBy.get(i)).getOrder() == Order.ASC;
        }
        EArrayConstructor expr = new EArrayConstructor(Object.class, orderByExpr);
        Evaluator<Object[]> ev = this.evaluatorFactory.create((List<? extends Expr<?>>)sources, expr);
        List itAsList = IteratorUtils.toList(it);
        Collections.sort(itAsList, new MultiComparator(ev, directions));
        it = itAsList.iterator();
        return it;
    }

    protected <RT> Iterator<RT> handleSelect(Iterator<?> it, List<Expr<?>> sources, Expr<RT> projection) throws Exception {
        Iterator<RT> rv = this.iteratorFactory.transform(it, sources, projection);
        if (this.getMetadata().isDistinct()) {
            rv = this.asDistinctIterator(rv);
        }
        return rv;
    }

    private <RT> Iterator<RT> asDistinctIterator(Iterator<RT> rv) {
        if (!this.arrayProjection) {
            return new UniqueFilterIterator(rv);
        }
        return new FilterIterator(rv, new Predicate(){
            private Set<List<Object>> set = new HashSet<List<Object>>();

            public boolean evaluate(Object object) {
                return this.set.add(Arrays.asList((Object[])object));
            }
        });
    }

    public Iterator<Object[]> iterate(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        this.arrayProjection = true;
        Expr[] full = (Expr[])this.asArray(new Expr[rest.length + 2], first, second, rest);
        EArrayConstructor projection = new EArrayConstructor(Object.class, full);
        return this.iterate((Expr)projection);
    }

    public <RT> Iterator<RT> iterate(Expr<RT> projection) {
        this.addToProjection(new Expr[]{projection});
        try {
            return this.createPagedIterator(projection);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <RT> SearchResults<RT> listResults(Expr<RT> projection) {
        List list;
        QueryModifiers modifiers = this.getMetadata().getModifiers();
        try {
            list = IteratorUtils.toList(this.createIterator(projection));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (list.isEmpty()) {
            return SearchResults.emptyResults();
        }
        if (!modifiers.isRestricting()) {
            return new SearchResults(list, modifiers, (long)list.size());
        }
        int start = 0;
        int end = list.size();
        if (modifiers.getOffset() != null) {
            if (modifiers.getOffset() < (long)list.size()) {
                start = modifiers.getOffset().intValue();
            } else {
                return new SearchResults(Collections.emptyList(), modifiers, (long)list.size());
            }
        }
        if (modifiers.getLimit() != null) {
            end = (int)Math.min((long)start + modifiers.getLimit(), (long)list.size());
        }
        return new SearchResults(list.subList(start, end), modifiers, (long)list.size());
    }
}

