/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.google.common.base.Function;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.util.BeanUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;

public class BeanSerializer
implements Serializer {
    private static final Function<Property, Parameter> propertyToParameter = new Function<Property, Parameter>(){

        public Parameter apply(Property input) {
            return new Parameter(input.getName(), input.getType());
        }
    };
    private final boolean propertyAnnotations;
    private final String javadocSuffix;
    private boolean addToString;
    private boolean addFullConstructor;
    private boolean printSupertype = false;

    public BeanSerializer() {
        this(true, " is a Querydsl bean type");
    }

    public BeanSerializer(String javadocSuffix) {
        this(true, javadocSuffix);
    }

    public BeanSerializer(boolean propertyAnnotations) {
        this(propertyAnnotations, " is a Querydsl bean type");
    }

    public BeanSerializer(boolean propertyAnnotations, String javadocSuffix) {
        this.propertyAnnotations = propertyAnnotations;
        this.javadocSuffix = javadocSuffix;
    }

    @Override
    public void serialize(EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        if (!model.getPackageName().isEmpty()) {
            writer.packageDecl(model.getPackageName());
        }
        Set<String> importedClasses = this.getAnnotationTypes(model);
        importedClasses.add(Generated.class.getName());
        if (model.hasLists()) {
            importedClasses.add(List.class.getName());
        }
        if (model.hasCollections()) {
            importedClasses.add(Collection.class.getName());
        }
        if (model.hasSets()) {
            importedClasses.add(Set.class.getName());
        }
        if (model.hasMaps()) {
            importedClasses.add(Map.class.getName());
        }
        if (this.addToString && model.hasArrays()) {
            importedClasses.add(Arrays.class.getName());
        }
        writer.importClasses(importedClasses.toArray(new String[importedClasses.size()]));
        writer.javadoc(new String[]{simpleName + this.javadocSuffix});
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.line(new String[]{"@Generated(\"", this.getClass().getName(), "\")"});
        if (this.printSupertype && model.getSuperType() != null) {
            writer.beginClass((Type)model, model.getSuperType().getType(), new Type[0]);
        } else {
            writer.beginClass((Type)model);
        }
        this.bodyStart(model, writer);
        if (this.addFullConstructor) {
            this.addFullConstructor(model, writer);
        }
        for (Property property : model.getProperties()) {
            if (this.propertyAnnotations) {
                for (Annotation annotation : property.getAnnotations()) {
                    writer.annotation(annotation);
                }
            }
            writer.privateField(property.getType(), property.getEscapedName());
        }
        for (Property property : model.getProperties()) {
            String propertyName = property.getEscapedName();
            writer.beginPublicMethod(property.getType(), "get" + BeanUtils.capitalize((String)propertyName), new Parameter[0]);
            writer.line(new String[]{"return ", propertyName, ";"});
            writer.end();
            Parameter parameter = new Parameter(propertyName, property.getType());
            writer.beginPublicMethod((Type)Types.VOID, "set" + BeanUtils.capitalize((String)propertyName), new Parameter[]{parameter});
            writer.line(new String[]{"this.", propertyName, " = ", propertyName, ";"});
            writer.end();
        }
        if (this.addToString) {
            this.addToString(model, writer);
        }
        this.bodyEnd(model, writer);
        writer.end();
    }

    protected void addFullConstructor(EntityType model, CodeWriter writer) throws IOException {
        writer.beginConstructor(new Parameter[0]);
        writer.end();
        writer.beginConstructor(model.getProperties(), propertyToParameter);
        for (Property property : model.getProperties()) {
            writer.line(new String[]{"this.", property.getEscapedName(), " = ", property.getEscapedName(), ";"});
        }
        writer.end();
    }

    protected void addToString(EntityType model, CodeWriter writer) throws IOException {
        writer.beginPublicMethod((Type)Types.STRING, "toString", new Parameter[0]);
        StringBuilder builder = new StringBuilder();
        for (Property property : model.getProperties()) {
            String propertyName = property.getEscapedName();
            if (builder.length() > 0) {
                builder.append(" + \", ");
            } else {
                builder.append("\"");
            }
            builder.append(propertyName + " = \" + ");
            if (property.getType().getCategory() == TypeCategory.ARRAY) {
                builder.append("Arrays.toString(" + propertyName + ")");
                continue;
            }
            builder.append(propertyName);
        }
        writer.line(new String[]{" return ", builder.toString(), ";"});
        writer.end();
    }

    protected void bodyStart(EntityType model, CodeWriter writer) throws IOException {
    }

    protected void bodyEnd(EntityType model, CodeWriter writer) throws IOException {
    }

    private Set<String> getAnnotationTypes(EntityType model) {
        HashSet<String> imports = new HashSet<String>();
        for (Annotation annotation : model.getAnnotations()) {
            imports.add(annotation.annotationType().getName());
        }
        if (this.propertyAnnotations) {
            for (Property property : model.getProperties()) {
                for (Annotation annotation : property.getAnnotations()) {
                    imports.add(annotation.annotationType().getName());
                }
            }
        }
        return imports;
    }

    public void setAddToString(boolean addToString) {
        this.addToString = addToString;
    }

    public void setAddFullConstructor(boolean addFullConstructor) {
        this.addFullConstructor = addFullConstructor;
    }

    public void setPrintSupertype(boolean printSupertype) {
        this.printSupertype = printSupertype;
    }
}

