/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Supertype;
import java.util.Collections;
import java.util.List;

public final class TypeResolver {
    public static Type resolve(Type type, Type declaringType, EntityType context) {
        List<Type> result;
        Object resolved = type;
        if (resolved instanceof EntityType) {
            resolved = ((EntityType)resolved).getInnerType();
        }
        if (resolved instanceof TypeExtends && !(result = TypeResolver.resolveTypeExtends((TypeExtends)resolved, declaringType, context)).isEmpty()) {
            resolved = result.get(0);
            declaringType = result.get(1);
        }
        if (!resolved.getParameters().isEmpty()) {
            resolved = TypeResolver.resolveWithParameters(resolved, declaringType, context);
        }
        if (type instanceof EntityType) {
            resolved = !((EntityType)type).getInnerType().equals(resolved) ? new EntityType((Type)resolved, ((EntityType)type).getSuperTypes()) : type;
        }
        return resolved;
    }

    private static List<Type> resolveTypeExtends(TypeExtends typeExtends, Type declaringType, EntityType context) {
        if (typeExtends.getVarName() == null) {
            return Collections.emptyList();
        }
        int index = -1;
        for (int i = 0; i < declaringType.getParameters().size(); ++i) {
            Type param = (Type)declaringType.getParameters().get(i);
            if (param instanceof EntityType) {
                param = ((EntityType)param).getInnerType();
            }
            if (!(param instanceof TypeExtends) || !Objects.equal((Object)((TypeExtends)param).getVarName(), (Object)typeExtends.getVarName())) continue;
            index = i;
        }
        if (index > -1) {
            Supertype type = context.getSuperType();
            while (!type.getEntityType().equals(declaringType)) {
                type = type.getEntityType().getSuperType();
            }
            return Lists.newArrayList((Object[])new Type[]{(Type)type.getType().getParameters().get(index), type.getType()});
        }
        return Collections.emptyList();
    }

    private static Type resolveWithParameters(Type type, Type declaringType, EntityType context) {
        Type[] params = new Type[type.getParameters().size()];
        boolean transformed = false;
        for (int i = 0; i < type.getParameters().size(); ++i) {
            Type param = (Type)type.getParameters().get(i);
            if (param == null) continue;
            params[i] = TypeResolver.resolve(param, declaringType, context);
            if (params[i] == param) continue;
            transformed = true;
        }
        if (transformed) {
            return new SimpleType(type.getCategory(), type.getFullName(), type.getPackageName(), type.getSimpleName(), type.isFinal(), type.isPrimitive(), params);
        }
        return type;
    }

    private TypeResolver() {
    }
}

