/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt.jpa;

import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.DefaultConfiguration;
import com.mysema.query.apt.VisitorConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class JPAConfiguration
extends DefaultConfiguration {
    private List<Class<? extends Annotation>> annotations = this.getAnnotations();

    public JPAConfiguration(RoundEnvironment roundEnv, Class<? extends Annotation> entityAnn, Class<? extends Annotation> superTypeAnn, Class<? extends Annotation> embeddableAnn, Class<? extends Annotation> skipAnn) throws ClassNotFoundException {
        super(roundEnv, entityAnn, superTypeAnn, embeddableAnn, skipAnn);
    }

    protected List<Class<? extends Annotation>> getAnnotations() throws ClassNotFoundException {
        ArrayList<Class<? extends Annotation>> rv = new ArrayList<Class<? extends Annotation>>();
        rv.add(QueryType.class);
        for (String simpleName : Arrays.asList("Column", "Embedded", "EmbeddedId", "GeneratedValue", "Id", "Version", "JoinColumn", "ManyToOne", "OneToMany", "PrimaryKeyJoinColumn")) {
            rv.add(Class.forName("javax.persistence." + simpleName));
        }
        return rv;
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        boolean fields = false;
        boolean methods = false;
        for (Element element : elements) {
            if (!this.hasRelevantAnnotation(element)) continue;
            if (element.getKind().equals((Object)ElementKind.FIELD)) {
                fields = true;
                continue;
            }
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            methods = true;
        }
        if (fields && !methods) {
            return VisitorConfig.FIELDS_ONLY;
        }
        if (methods && !fields) {
            return VisitorConfig.METHODS_ONLY;
        }
        return VisitorConfig.ALL;
    }

    private boolean hasRelevantAnnotation(Element element) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (element.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }
}

