/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryInit;
import com.mysema.query.annotations.QueryMethod;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.APTException;
import com.mysema.query.apt.APTTypeFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.Constructor;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Method;
import com.mysema.query.codegen.Parameter;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.Type;
import com.mysema.query.codegen.TypeCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public final class ElementHandler {
    private final Configuration configuration;
    private final APTTypeFactory typeFactory;

    public ElementHandler(Configuration configuration, APTTypeFactory typeFactory) {
        this.configuration = configuration;
        this.typeFactory = typeFactory;
    }

    private Type getType(VariableElement element) {
        QueryType qt;
        Type rv = this.typeFactory.create(element.asType());
        if (element.getAnnotation(QueryType.class) != null && (qt = element.getAnnotation(QueryType.class)).value() != PropertyType.NONE) {
            TypeCategory typeCategory = TypeCategory.get((PropertyType)qt.value());
            rv = rv.as(typeCategory);
        }
        return rv;
    }

    public void handleConstructors(EntityType entityModel, List<? extends Element> elements) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(elements)) {
            if (!this.configuration.isValidConstructor(constructor)) continue;
            List<Parameter> parameters = this.transformParams(constructor.getParameters());
            entityModel.addConstructor(new Constructor(parameters));
        }
    }

    public void handleFieldProperty(EntityType entityModel, VariableElement field, Map<String, Property> properties, Set<String> blockedProperties, Map<String, TypeCategory> types) {
        String name = field.getSimpleName().toString();
        try {
            Type fieldType = this.typeFactory.create(field.asType());
            if (field.getAnnotation(QueryType.class) != null) {
                TypeCategory typeCategory = TypeCategory.get((PropertyType)field.getAnnotation(QueryType.class).value());
                if (typeCategory == null) {
                    blockedProperties.add(name);
                    return;
                }
                fieldType = fieldType.as(typeCategory);
                types.put(name, typeCategory);
            }
            String[] inits = new String[]{};
            if (field.getAnnotation(QueryInit.class) != null) {
                inits = field.getAnnotation(QueryInit.class).value();
            }
            properties.put(name, new Property(entityModel, name, fieldType, inits));
        }
        catch (IllegalArgumentException ex) {
            StringBuilder builder = new StringBuilder();
            builder.append("Caught exception for field ");
            builder.append(entityModel.getFullName()).append("#").append(field.getSimpleName());
            throw new APTException(builder.toString(), ex);
        }
    }

    public void handleMethodProperty(EntityType entityModel, String propertyName, ExecutableElement method, Map<String, Property> properties, Set<String> blockedProperties, Map<String, TypeCategory> types) {
        try {
            Type propertyType = this.typeFactory.create(method.getReturnType());
            if (method.getAnnotation(QueryType.class) != null) {
                TypeCategory typeCategory = TypeCategory.get((PropertyType)method.getAnnotation(QueryType.class).value());
                if (typeCategory == null) {
                    blockedProperties.add(propertyName);
                    return;
                }
                if (blockedProperties.contains(propertyName)) {
                    return;
                }
                propertyType = propertyType.as(typeCategory);
            } else if (types.containsKey(propertyName)) {
                propertyType = propertyType.as(types.get(propertyName));
            }
            String[] inits = new String[]{};
            if (method.getAnnotation(QueryInit.class) != null) {
                inits = method.getAnnotation(QueryInit.class).value();
            }
            properties.put(propertyName, new Property(entityModel, propertyName, propertyType, inits));
        }
        catch (IllegalArgumentException ex) {
            StringBuilder builder = new StringBuilder();
            builder.append("Caught exception for method ");
            builder.append(entityModel.getFullName()).append("#").append(method.getSimpleName());
            throw new APTException(builder.toString(), ex);
        }
    }

    public EntityType handleNormalType(TypeElement e) {
        String name;
        EntityType entityType = this.typeFactory.createEntityType(e.asType());
        List<? extends Element> elements = e.getEnclosedElements();
        VisitorConfig config = this.configuration.getConfig(e, elements);
        HashSet<String> blockedProperties = new HashSet<String>();
        HashMap<String, Property> properties = new HashMap<String, Property>();
        HashMap<String, TypeCategory> types = new HashMap<String, TypeCategory>();
        HashSet<Method> queryMethods = new HashSet<Method>();
        if (config.visitConstructors()) {
            this.handleConstructors(entityType, elements);
        }
        if (config.visitFieldProperties()) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(elements)) {
                name = variableElement.getSimpleName().toString();
                if (this.configuration.isValidField(variableElement)) {
                    this.handleFieldProperty(entityType, variableElement, properties, blockedProperties, types);
                    continue;
                }
                if (!this.configuration.isBlockedField(variableElement)) continue;
                blockedProperties.add(name);
            }
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(elements)) {
            if (executableElement.getAnnotation(QueryMethod.class) != null) {
                this.handleQueryMethod(entityType, executableElement, queryMethods);
                continue;
            }
            if (!config.visitMethodProperties()) continue;
            name = executableElement.getSimpleName().toString();
            if (name.startsWith("get") && executableElement.getParameters().isEmpty()) {
                name = StringUtils.uncapitalize((String)name.substring(3));
            } else {
                if (!name.startsWith("is") || !executableElement.getParameters().isEmpty()) continue;
                name = StringUtils.uncapitalize((String)name.substring(2));
            }
            if (this.configuration.isValidGetter(executableElement)) {
                this.handleMethodProperty(entityType, name, executableElement, properties, blockedProperties, types);
                continue;
            }
            if (!this.configuration.isBlockedGetter(executableElement)) continue;
            blockedProperties.add(name);
        }
        for (Method method : queryMethods) {
            entityType.addMethod(method);
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (blockedProperties.contains(entry.getKey())) continue;
            entityType.addProperty((Property)entry.getValue());
        }
        return entityType;
    }

    public EntityType handleProjectionType(TypeElement e) {
        Type c = this.typeFactory.create(e.asType());
        EntityType entityModel = new EntityType(this.configuration.getNamePrefix(), c.as(TypeCategory.ENTITY));
        List<? extends Element> elements = e.getEnclosedElements();
        this.handleConstructors(entityModel, elements);
        return entityModel;
    }

    public void handleQueryMethod(EntityType entityModel, ExecutableElement method, Set<Method> queryMethods) {
        String name = method.getSimpleName().toString();
        QueryMethod queryMethod = method.getAnnotation(QueryMethod.class);
        Type returnType = this.typeFactory.create(method.getReturnType());
        Method methodModel = new Method(entityModel, name, queryMethod.value(), this.transformParams(method.getParameters()), returnType);
        queryMethods.add(methodModel);
    }

    private List<Parameter> transformParams(List<? extends VariableElement> params) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(params.size());
        for (VariableElement variableElement : params) {
            Type paramType = this.getType(variableElement);
            parameters.add(new Parameter(variableElement.getSimpleName().toString(), paramType));
        }
        return parameters;
    }
}

