/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.commons.lang.Assert;
import com.mysema.query.annotations.QueryExtensions;
import com.mysema.query.annotations.QueryMethod;
import com.mysema.query.annotations.QueryProjection;
import com.mysema.query.annotations.QuerydslVariables;
import com.mysema.query.apt.APTTypeModelFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.ElementHandler;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.EntityModelFactory;
import com.mysema.query.codegen.MethodModel;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.codegen.TypeModel;
import com.mysema.query.codegen.TypeModelFactory;
import com.mysema.util.JavaWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class Processor {
    private final Map<String, EntityModel> actualSupertypes = new HashMap<String, EntityModel>();
    private final Map<String, EntityModel> allSupertypes = new HashMap<String, EntityModel>();
    private final Configuration configuration;
    private final Map<String, EntityModel> dtos = new HashMap<String, EntityModel>();
    private final Map<String, EntityModel> extensionTypes = new HashMap<String, EntityModel>();
    private final Map<String, EntityModel> embeddables = new HashMap<String, EntityModel>();
    private final EntityModelFactory entityModelFactory;
    private final Map<String, EntityModel> entityTypes = new HashMap<String, EntityModel>();
    private final ElementHandler entityVisitor;
    private final ProcessingEnvironment env;
    private final RoundEnvironment roundEnv;
    private final APTTypeModelFactory typeFactory;

    public Processor(ProcessingEnvironment env, RoundEnvironment roundEnv, Configuration configuration) {
        this.env = (ProcessingEnvironment)Assert.notNull((Object)env);
        this.roundEnv = (RoundEnvironment)Assert.notNull((Object)roundEnv);
        this.configuration = (Configuration)Assert.notNull((Object)configuration);
        ArrayList<Class<? extends Annotation>> anns = new ArrayList<Class<? extends Annotation>>();
        anns.add(configuration.getEntityAnn());
        if (configuration.getSuperTypeAnn() != null) {
            anns.add(configuration.getSuperTypeAnn());
        }
        if (configuration.getEmbeddableAnn() != null) {
            anns.add(configuration.getEmbeddableAnn());
        }
        TypeModelFactory factory = new TypeModelFactory(anns);
        this.typeFactory = new APTTypeModelFactory(env, configuration, factory, anns);
        this.entityModelFactory = configuration.getSkipAnn() != null ? new EntityModelFactory(factory, configuration.getSkipAnn()) : new EntityModelFactory(factory);
        this.entityVisitor = new ElementHandler(configuration, this.typeFactory);
    }

    private void addSupertypeFields(EntityModel model, Map<String, EntityModel> superTypes) {
        String stype;
        Class<?> superClass;
        boolean singleSuperType = model.getSuperTypes().size() == 1;
        for (String stype2 : model.getSuperTypes()) {
            if (!superTypes.containsKey(stype2)) continue;
            Stack<String> stypeStack = new Stack<String>();
            stypeStack.push(stype2);
            while (!stypeStack.isEmpty()) {
                String top = (String)stypeStack.pop();
                if (!superTypes.containsKey(top)) continue;
                EntityModel sdecl = superTypes.get(top);
                if (singleSuperType && model.getSuperTypes().contains(top)) {
                    model.setSuperModel(sdecl);
                }
                model.include(sdecl);
                for (String type : sdecl.getSuperTypes()) {
                    stypeStack.push(type);
                }
            }
        }
        if (model.getSuperModel() == null && singleSuperType && (superClass = this.safeClassForName(stype = (String)model.getSuperTypes().iterator().next())) != null && !superClass.equals(Object.class) && (this.configuration.getSuperTypeAnn() == null || superClass.getAnnotation(this.configuration.getSuperTypeAnn()) != null || superClass.getAnnotation(this.configuration.getEntityAnn()) != null)) {
            EntityModel type = this.entityModelFactory.create(superClass, this.configuration.getNamePrefix());
            model.include(type);
        }
    }

    public void process() {
        this.processCustomTypes();
        this.processExtensions();
        if (this.configuration.getSuperTypeAnn() != null) {
            this.processSupertypes();
            this.allSupertypes.putAll(this.actualSupertypes);
        }
        this.processEntities();
        if (this.configuration.getEmbeddableAnn() != null) {
            this.processEmbeddables();
        }
        this.processDTOs();
        for (String string : this.entityTypes.keySet()) {
            this.extensionTypes.remove(string);
        }
        this.serialize(this.configuration.getSupertypeSerializer(), this.actualSupertypes);
        this.serialize(this.configuration.getEntitySerializer(), this.entityTypes);
        this.serialize(this.configuration.getEmbeddableSerializer(), this.extensionTypes);
        this.serialize(this.configuration.getEmbeddableSerializer(), this.embeddables);
        this.serialize(this.configuration.getDTOSerializer(), this.dtos);
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QuerydslVariables.class)) {
            if (!(element instanceof PackageElement)) continue;
            QuerydslVariables vars = element.getAnnotation(QuerydslVariables.class);
            PackageElement packageElement = (PackageElement)element;
            ArrayList<EntityModel> models = new ArrayList<EntityModel>();
            for (EntityModel model : this.entityTypes.values()) {
                if (!model.getPackageName().equals(packageElement.getQualifiedName().toString())) continue;
                models.add(model);
            }
            this.serializeVariableList(packageElement.getQualifiedName().toString(), vars, models);
        }
    }

    private void processExtensions() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryExtensions.class)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().toString().equals(QueryExtensions.class.getSimpleName())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                    TypeMirror type = (TypeMirror)entry.getValue().getValue();
                    this.handleExtensionType(type, element);
                }
            }
        }
    }

    private void handleExtensionType(TypeMirror type, Element element) {
        EntityModel entityModel = this.typeFactory.createEntityModel(type);
        HashSet<MethodModel> queryMethods = new HashSet<MethodModel>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
            if (executableElement.getAnnotation(QueryMethod.class) == null) continue;
            this.entityVisitor.handleQueryMethod(entityModel, executableElement, queryMethods);
        }
        for (MethodModel methodModel : queryMethods) {
            entityModel.addMethod(methodModel);
        }
        this.extensionTypes.put(entityModel.getFullName(), entityModel);
    }

    private void processCustomTypes() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryMethod.class)) {
            Element element2 = element.getEnclosingElement();
            if (element2.getAnnotation(QueryExtensions.class) != null || element2.getAnnotation(this.configuration.getEntityAnn()) != null || this.configuration.getSuperTypeAnn() != null && element2.getAnnotation(this.configuration.getSuperTypeAnn()) != null || this.configuration.getEmbeddableAnn() != null && element2.getAnnotation(this.configuration.getEmbeddableAnn()) != null) continue;
            this.handleExtensionType(element2.asType(), element2);
        }
    }

    private void processDTOs() {
        HashSet<Element> visitedDTOTypes = new HashSet<Element>();
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryProjection.class)) {
            Element parent = element.getEnclosingElement();
            if (parent.getAnnotation(this.configuration.getEntityAnn()) != null || parent.getAnnotation(this.configuration.getEmbeddableAnn()) != null || visitedDTOTypes.contains(parent)) continue;
            EntityModel model = this.entityVisitor.handleProjectionType((TypeElement)parent);
            this.dtos.put(model.getFullName(), model);
            visitedDTOTypes.add(parent);
        }
    }

    private void processEmbeddables() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(this.configuration.getEmbeddableAnn())) {
            EntityModel model = this.entityVisitor.handleNormalType((TypeElement)element);
            this.embeddables.put(model.getFullName(), model);
        }
        this.allSupertypes.putAll(this.embeddables);
        for (EntityModel entityModel : this.embeddables.values()) {
            this.addSupertypeFields(entityModel, this.allSupertypes);
        }
    }

    private void processEntities() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(this.configuration.getEntityAnn())) {
            if (this.configuration.getEmbeddableAnn() != null && element.getAnnotation(this.configuration.getEmbeddableAnn()) != null) continue;
            EntityModel model = this.entityVisitor.handleNormalType((TypeElement)element);
            this.entityTypes.put(model.getFullName(), model);
        }
        this.allSupertypes.putAll(this.entityTypes);
        for (EntityModel entityModel : this.entityTypes.values()) {
            this.addSupertypeFields(entityModel, this.allSupertypes);
        }
    }

    private void processSupertypes() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(this.configuration.getSuperTypeAnn())) {
            if (this.configuration.getEmbeddableAnn() != null && element.getAnnotation(this.configuration.getEmbeddableAnn()) != null) continue;
            EntityModel model = this.entityVisitor.handleNormalType((TypeElement)element);
            this.actualSupertypes.put(model.getFullName(), model);
        }
        for (EntityModel entityModel : this.actualSupertypes.values()) {
            this.addSupertypeFields(entityModel, this.actualSupertypes);
        }
    }

    @Nullable
    private Class<?> safeClassForName(String stype) {
        try {
            return Class.forName(stype);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeVariableList(String packageName, QuerydslVariables vars, List<EntityModel> models) {
        String className = packageName + "." + vars.value();
        TypeMappings typeMappings = this.configuration.getTypeMappings();
        try {
            JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
            Writer w = fileObject.openWriter();
            try {
                JavaWriter writer = new JavaWriter((Appendable)w);
                writer.packageDecl(packageName);
                writer.nl();
                if (vars.asInterface()) {
                    writer.beginInterface(vars.value(), new String[0]);
                } else {
                    writer.beginClass(vars.value(), null, new String[0]);
                }
                for (EntityModel model : models) {
                    String queryType = typeMappings.getPathType((TypeModel)model, model, true);
                    String simpleName = model.getUncapSimpleName();
                    writer.publicStaticFinal(queryType, simpleName, "new " + queryType + "(\"" + simpleName + "\")");
                }
                writer.end();
            }
            finally {
                w.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(Serializer serializer, Map<String, EntityModel> models) {
        Messager msg = this.env.getMessager();
        for (EntityModel model : models.values()) {
            msg.printMessage(Diagnostic.Kind.NOTE, model.getFullName() + " is processed");
            try {
                String packageName = model.getPackageName();
                String localName = this.configuration.getTypeMappings().getPathType((TypeModel)model, model, true);
                String className = packageName + "." + localName;
                JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
                Writer writer = fileObject.openWriter();
                try {
                    SerializerConfig serializerConfig = this.configuration.getSerializerConfig(model);
                    serializer.serialize(model, serializerConfig, writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                msg.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
    }
}

