/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryInit;
import com.mysema.query.annotations.QueryMethod;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.APTTypeModelFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.MethodModel;
import com.mysema.query.codegen.ParameterModel;
import com.mysema.query.codegen.PropertyModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public final class ElementHandler {
    private final Configuration configuration;
    private final APTTypeModelFactory typeFactory;

    public ElementHandler(Configuration configuration, APTTypeModelFactory typeFactory) {
        this.configuration = configuration;
        this.typeFactory = typeFactory;
    }

    private TypeModel getType(VariableElement element) {
        QueryType qt;
        TypeModel rv = this.typeFactory.create(element.asType());
        if (element.getAnnotation(QueryType.class) != null && (qt = element.getAnnotation(QueryType.class)).value() != PropertyType.NONE) {
            TypeCategory typeCategory = TypeCategory.get((PropertyType)qt.value());
            rv = rv.as(typeCategory);
        }
        return rv;
    }

    public void handleConstructors(EntityModel entityModel, List<? extends Element> elements) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(elements)) {
            if (!this.configuration.isValidConstructor(constructor)) continue;
            List<ParameterModel> parameters = this.transformParams(constructor.getParameters());
            entityModel.addConstructor(new ConstructorModel(parameters));
        }
    }

    public void handleFieldProperty(EntityModel entityModel, VariableElement field, Map<String, PropertyModel> properties, Set<String> blockedProperties, Map<String, TypeCategory> types) {
        String name = field.getSimpleName().toString();
        try {
            TypeModel fieldType = this.typeFactory.create(field.asType());
            if (field.getAnnotation(QueryType.class) != null) {
                TypeCategory typeCategory = TypeCategory.get((PropertyType)field.getAnnotation(QueryType.class).value());
                if (typeCategory == null) {
                    blockedProperties.add(name);
                    return;
                }
                fieldType = fieldType.as(typeCategory);
                types.put(name, typeCategory);
            }
            String[] inits = new String[]{};
            if (field.getAnnotation(QueryInit.class) != null) {
                inits = field.getAnnotation(QueryInit.class).value();
            }
            properties.put(name, new PropertyModel(entityModel, name, fieldType, inits));
        }
        catch (IllegalArgumentException ex) {
            StringBuilder builder = new StringBuilder();
            builder.append("Caught exception for field ");
            builder.append(entityModel.getFullName()).append("#").append(field.getSimpleName());
            throw new RuntimeException(builder.toString(), ex);
        }
    }

    public void handleMethodProperty(EntityModel entityModel, String propertyName, ExecutableElement method, Map<String, PropertyModel> properties, Set<String> blockedProperties, Map<String, TypeCategory> types) {
        try {
            TypeModel propertyType = this.typeFactory.create(method.getReturnType());
            if (method.getAnnotation(QueryType.class) != null) {
                TypeCategory typeCategory = TypeCategory.get((PropertyType)method.getAnnotation(QueryType.class).value());
                if (typeCategory == null) {
                    blockedProperties.add(propertyName);
                    return;
                }
                if (blockedProperties.contains(propertyName)) {
                    return;
                }
                propertyType = propertyType.as(typeCategory);
            } else if (types.containsKey(propertyName)) {
                propertyType = propertyType.as(types.get(propertyName));
            }
            String[] inits = new String[]{};
            if (method.getAnnotation(QueryInit.class) != null) {
                inits = method.getAnnotation(QueryInit.class).value();
            }
            properties.put(propertyName, new PropertyModel(entityModel, propertyName, propertyType, inits));
        }
        catch (IllegalArgumentException ex) {
            StringBuilder builder = new StringBuilder();
            builder.append("Caught exception for method ");
            builder.append(entityModel.getFullName()).append("#").append(method.getSimpleName());
            throw new RuntimeException(builder.toString(), ex);
        }
    }

    public EntityModel handleNormalType(TypeElement e) {
        String name;
        EntityModel entityModel = this.typeFactory.createEntityModel(e.asType());
        List<? extends Element> elements = e.getEnclosedElements();
        VisitorConfig config = this.configuration.getConfig(e, elements);
        HashSet<String> blockedProperties = new HashSet<String>();
        HashMap<String, PropertyModel> properties = new HashMap<String, PropertyModel>();
        HashMap<String, TypeCategory> types = new HashMap<String, TypeCategory>();
        HashSet<MethodModel> queryMethods = new HashSet<MethodModel>();
        if (config.visitConstructors()) {
            this.handleConstructors(entityModel, elements);
        }
        if (config.visitFieldProperties()) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(elements)) {
                name = variableElement.getSimpleName().toString();
                if (this.configuration.isValidField(variableElement)) {
                    this.handleFieldProperty(entityModel, variableElement, properties, blockedProperties, types);
                    continue;
                }
                if (!this.configuration.isBlockedField(variableElement)) continue;
                blockedProperties.add(name);
            }
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(elements)) {
            if (executableElement.getAnnotation(QueryMethod.class) != null) {
                this.handleQueryMethod(entityModel, executableElement, queryMethods);
                continue;
            }
            if (!config.visitMethodProperties()) continue;
            name = executableElement.getSimpleName().toString();
            if (name.startsWith("get") && executableElement.getParameters().isEmpty()) {
                name = StringUtils.uncapitalize((String)name.substring(3));
            } else {
                if (!name.startsWith("is") || !executableElement.getParameters().isEmpty()) continue;
                name = StringUtils.uncapitalize((String)name.substring(2));
            }
            if (this.configuration.isValidGetter(executableElement)) {
                this.handleMethodProperty(entityModel, name, executableElement, properties, blockedProperties, types);
                continue;
            }
            if (!this.configuration.isBlockedGetter(executableElement)) continue;
            blockedProperties.add(name);
        }
        for (MethodModel methodModel : queryMethods) {
            entityModel.addMethod(methodModel);
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (blockedProperties.contains(entry.getKey())) continue;
            entityModel.addProperty((PropertyModel)entry.getValue());
        }
        return entityModel;
    }

    public EntityModel handleProjectionType(TypeElement e) {
        TypeModel c = this.typeFactory.create(e.asType());
        EntityModel entityModel = new EntityModel(this.configuration.getNamePrefix(), c.as(TypeCategory.ENTITY));
        List<? extends Element> elements = e.getEnclosedElements();
        this.handleConstructors(entityModel, elements);
        return entityModel;
    }

    public void handleQueryMethod(EntityModel entityModel, ExecutableElement method, Set<MethodModel> queryMethods) {
        String name = method.getSimpleName().toString();
        QueryMethod queryMethod = method.getAnnotation(QueryMethod.class);
        TypeModel returnType = this.typeFactory.create(method.getReturnType());
        MethodModel methodModel = new MethodModel(entityModel, name, queryMethod.value(), this.transformParams(method.getParameters()), returnType);
        queryMethods.add(methodModel);
    }

    private List<ParameterModel> transformParams(List<? extends VariableElement> params) {
        ArrayList<ParameterModel> parameters = new ArrayList<ParameterModel>(params.size());
        for (VariableElement variableElement : params) {
            TypeModel paramType = this.getType(variableElement);
            parameters.add(new ParameterModel(variableElement.getSimpleName().toString(), paramType));
        }
        return parameters;
    }
}

