/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt.jpa;

import com.mysema.query.apt.Processor;
import com.mysema.query.apt.SimpleConfiguration;
import com.mysema.query.apt.jpa.JPAConfiguration;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JPAAnnotationProcessor
extends AbstractProcessor {
    protected Class<? extends Annotation> entity;
    protected Class<? extends Annotation> superType;
    protected Class<? extends Annotation> embeddable;
    protected Class<? extends Annotation> skip;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running " + this.getClass().getSimpleName());
            this.entity = Class.forName("javax.persistence.Entity");
            this.superType = Class.forName("javax.persistence.MappedSuperclass");
            this.embeddable = Class.forName("javax.persistence.Embeddable");
            this.skip = Class.forName("javax.persistence.Transient");
            SimpleConfiguration configuration = this.createConfiguration();
            Processor processor = new Processor(this.processingEnv, configuration);
            processor.process(roundEnv);
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected SimpleConfiguration createConfiguration() throws ClassNotFoundException {
        return new JPAConfiguration(this.entity, this.superType, this.embeddable, this.skip);
    }
}

