/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.commons.lang.Assert;
import com.mysema.query.annotations.QueryProjection;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.DTOSerializer;
import com.mysema.query.codegen.EmbeddableSerializer;
import com.mysema.query.codegen.EntitySerializer;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SupertypeSerializer;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class SimpleConfiguration
implements Configuration {
    private String namePrefix = "Q";
    private final Serializer entitySerializer = new EntitySerializer();
    private final Serializer supertypeSerializer = new SupertypeSerializer();
    private final Serializer embeddableSerializer = new EmbeddableSerializer();
    private final Serializer dtoSerializer = new DTOSerializer();
    protected final Class<? extends Annotation> entityAnn;
    protected final Class<? extends Annotation> superTypeAnn;
    protected final Class<? extends Annotation> embeddableAnn;
    protected final Class<? extends Annotation> skipAnn;
    private boolean useFields = true;
    private boolean useGetters = true;

    public SimpleConfiguration(Class<? extends Annotation> entityAnn, Class<? extends Annotation> superTypeAnn, Class<? extends Annotation> embeddableAnn, Class<? extends Annotation> skipAnn) {
        this.entityAnn = (Class)Assert.notNull(entityAnn);
        this.superTypeAnn = superTypeAnn;
        this.embeddableAnn = embeddableAnn;
        this.skipAnn = skipAnn;
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        if (this.useFields) {
            if (this.useGetters) {
                return VisitorConfig.ALL;
            }
            return VisitorConfig.FIELDS_ONLY;
        }
        if (this.useGetters) {
            return VisitorConfig.METHODS_ONLY;
        }
        return VisitorConfig.NONE;
    }

    @Override
    public boolean isValidConstructor(ExecutableElement constructor) {
        return constructor.getModifiers().contains((Object)Modifier.PUBLIC) && constructor.getAnnotation(QueryProjection.class) != null && !constructor.getParameters().isEmpty();
    }

    @Override
    public boolean isValidField(VariableElement field) {
        return field.getAnnotation(this.skipAnn) == null && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isValidGetter(ExecutableElement getter) {
        return getter.getAnnotation(this.skipAnn) == null && !getter.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public Class<? extends Annotation> getEntityAnn() {
        return this.entityAnn;
    }

    @Override
    public Class<? extends Annotation> getSuperTypeAnn() {
        return this.superTypeAnn;
    }

    @Override
    public Class<? extends Annotation> getEmbeddableAnn() {
        return this.embeddableAnn;
    }

    @Override
    public Class<? extends Annotation> getSkipAnn() {
        return this.skipAnn;
    }

    @Override
    public void setUseGetters(boolean b) {
        this.useGetters = b;
    }

    @Override
    public void setUseFields(boolean b) {
        this.useFields = b;
    }

    @Override
    public String getNamePrefix() {
        return this.namePrefix;
    }

    @Override
    public Serializer getEntitySerializer() {
        return this.entitySerializer;
    }

    @Override
    public Serializer getSupertypeSerializer() {
        return this.supertypeSerializer;
    }

    @Override
    public Serializer getEmbeddableSerializer() {
        return this.embeddableSerializer;
    }

    @Override
    public boolean isUseFields() {
        return this.useFields;
    }

    @Override
    public boolean isUseGetters() {
        return this.useGetters;
    }

    @Override
    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public Serializer getDTOSerializer() {
        return this.dtoSerializer;
    }
}

