/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.commons.lang.Assert;
import com.mysema.query.annotations.QueryProjection;
import com.mysema.query.apt.APTModelFactory;
import com.mysema.query.apt.DTOElementVisitor;
import com.mysema.query.apt.EntityElementVisitor;
import com.mysema.query.apt.SimpleConfiguration;
import com.mysema.query.codegen.BeanModel;
import com.mysema.query.codegen.BeanModelFactory;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.TypeModelFactory;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import net.jcip.annotations.Immutable;

@Immutable
public class Processor {
    private final ProcessingEnvironment env;
    private final APTModelFactory typeFactory;
    private final SimpleConfiguration conf;
    private final BeanModelFactory classModelFactory;

    public Processor(ProcessingEnvironment env, SimpleConfiguration configuration) {
        this.conf = configuration;
        List<Class<Annotation>> anns = this.conf.getEmbeddableAnn() != null ? Arrays.asList(this.conf.getEntityAnn(), this.conf.getEmbeddableAnn()) : Arrays.asList(this.conf.getEntityAnn());
        this.env = (ProcessingEnvironment)Assert.notNull((Object)env);
        TypeModelFactory factory = new TypeModelFactory(anns);
        this.typeFactory = new APTModelFactory(env, factory, anns);
        this.classModelFactory = this.conf.getSkipAnn() != null ? new BeanModelFactory(factory, this.conf.getSkipAnn()) : new BeanModelFactory(factory);
    }

    public void process(RoundEnvironment roundEnv) {
        HashMap<String, BeanModel> superTypes = new HashMap<String, BeanModel>();
        EntityElementVisitor entityVisitor = new EntityElementVisitor(this.env, this.conf, this.typeFactory);
        if (this.conf.getSuperTypeAnn() != null) {
            this.handleSupertypes(roundEnv, superTypes, entityVisitor);
        }
        this.handleEntities(roundEnv, superTypes, entityVisitor);
        if (this.conf.getEmbeddableAnn() != null) {
            this.handleEmbeddables(roundEnv, superTypes, entityVisitor);
        }
        DTOElementVisitor dtoVisitor = new DTOElementVisitor(this.env, this.conf, this.typeFactory);
        HashMap<String, BeanModel> dtos = new HashMap<String, BeanModel>();
        HashSet<Element> visitedDTOTypes = new HashSet<Element>();
        for (Element element : roundEnv.getElementsAnnotatedWith(QueryProjection.class)) {
            Element parent = element.getEnclosingElement();
            if (parent.getAnnotation(this.conf.getEntityAnn()) != null || parent.getAnnotation(this.conf.getEmbeddableAnn()) != null || visitedDTOTypes.contains(parent)) continue;
            BeanModel model = parent.accept(dtoVisitor, null);
            dtos.put(model.getFullName(), model);
            visitedDTOTypes.add(parent);
        }
        if (!dtos.isEmpty()) {
            this.serialize(this.conf.getDTOSerializer(), dtos);
        }
    }

    private void handleSupertypes(RoundEnvironment roundEnv, Map<String, BeanModel> superTypes, EntityElementVisitor entityVisitor) {
        for (Element element : roundEnv.getElementsAnnotatedWith(this.conf.getSuperTypeAnn())) {
            if (this.conf.getEmbeddableAnn() != null && element.getAnnotation(this.conf.getEmbeddableAnn()) != null) continue;
            BeanModel model = element.accept(entityVisitor, null);
            superTypes.put(model.getFullName(), model);
        }
        for (BeanModel beanModel : superTypes.values()) {
            this.addSupertypeFields(beanModel, superTypes);
        }
        if (!superTypes.isEmpty()) {
            this.serialize(this.conf.getSupertypeSerializer(), superTypes);
        }
    }

    private void handleEmbeddables(RoundEnvironment roundEnv, Map<String, BeanModel> superTypes, EntityElementVisitor entityVisitor) {
        HashMap<String, BeanModel> embeddables = new HashMap<String, BeanModel>();
        for (Element element : roundEnv.getElementsAnnotatedWith(this.conf.getEmbeddableAnn())) {
            BeanModel model = element.accept(entityVisitor, null);
            embeddables.put(model.getFullName(), model);
        }
        superTypes.putAll(embeddables);
        for (BeanModel beanModel : embeddables.values()) {
            this.addSupertypeFields(beanModel, superTypes);
        }
        if (!embeddables.isEmpty()) {
            this.serialize(this.conf.getEmbeddableSerializer(), embeddables);
        }
    }

    private void handleEntities(RoundEnvironment roundEnv, Map<String, BeanModel> superTypes, EntityElementVisitor entityVisitor) {
        HashMap<String, BeanModel> entityTypes = new HashMap<String, BeanModel>();
        for (Element element : roundEnv.getElementsAnnotatedWith(this.conf.getEntityAnn())) {
            if (this.conf.getEmbeddableAnn() != null && element.getAnnotation(this.conf.getEmbeddableAnn()) != null) continue;
            BeanModel model = element.accept(entityVisitor, null);
            entityTypes.put(model.getFullName(), model);
        }
        superTypes.putAll(entityTypes);
        for (BeanModel beanModel : entityTypes.values()) {
            this.addSupertypeFields(beanModel, superTypes);
        }
        if (!entityTypes.isEmpty()) {
            this.serialize(this.conf.getEntitySerializer(), entityTypes);
        }
    }

    private void addSupertypeFields(BeanModel model, Map<String, BeanModel> superTypes) {
        String stype;
        Class<?> superClass;
        boolean singleSuperType = model.getSuperTypes().size() == 1;
        for (String stype2 : model.getSuperTypes()) {
            if (!superTypes.containsKey(stype2)) continue;
            Stack<String> stypeStack = new Stack<String>();
            stypeStack.push(stype2);
            while (!stypeStack.isEmpty()) {
                String top = (String)stypeStack.pop();
                if (!superTypes.containsKey(top)) continue;
                BeanModel sdecl = superTypes.get(top);
                if (singleSuperType && model.getSuperTypes().contains(top)) {
                    model.setSuperModel(sdecl);
                }
                model.include(sdecl);
                for (String type : sdecl.getSuperTypes()) {
                    stypeStack.push(type);
                }
            }
        }
        if (model.getSuperModel() == null && singleSuperType && (superClass = this.safeClassForName(stype = (String)model.getSuperTypes().iterator().next())) != null && !superClass.equals(Object.class) && (this.conf.getSuperTypeAnn() == null || superClass.getAnnotation(this.conf.getSuperTypeAnn()) != null || superClass.getAnnotation(this.conf.getEntityAnn()) != null)) {
            BeanModel type = this.classModelFactory.create(superClass, this.conf.getNamePrefix());
            model.include(type);
        }
    }

    private Class<?> safeClassForName(String stype) {
        try {
            return Class.forName(stype);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(Serializer serializer, Map<String, BeanModel> types) {
        Messager msg = this.env.getMessager();
        for (BeanModel type : types.values()) {
            msg.printMessage(Diagnostic.Kind.NOTE, type.getFullName() + " is processed");
            try {
                String packageName = type.getPackageName();
                String className = packageName + "." + this.conf.getNamePrefix() + type.getSimpleName();
                JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
                Writer writer = fileObject.openWriter();
                try {
                    serializer.serialize(type, writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                msg.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
    }
}

