/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryInit;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.APTModelFactory;
import com.mysema.query.apt.SimpleConfiguration;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.BeanModel;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.ParameterModel;
import com.mysema.query.codegen.PropertyModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public final class EntityElementVisitor
extends SimpleElementVisitor6<BeanModel, Void> {
    private final ProcessingEnvironment env;
    private final APTModelFactory typeFactory;
    private final SimpleConfiguration configuration;

    EntityElementVisitor(ProcessingEnvironment env, SimpleConfiguration conf, APTModelFactory typeFactory) {
        this.env = env;
        this.configuration = conf;
        this.typeFactory = typeFactory;
    }

    @Override
    public BeanModel visitType(TypeElement e, Void p) {
        StringBuilder builder;
        String[] inits;
        TypeCategory typeCategory;
        TypeModel typeModel;
        String name;
        Collection<Object> superTypes;
        Elements elementUtils = this.env.getElementUtils();
        if (e.getKind() == ElementKind.CLASS) {
            superTypes = Collections.singleton(this.typeFactory.create(e.getSuperclass(), elementUtils).getFullName());
        } else {
            superTypes = new ArrayList(e.getInterfaces().size());
            for (TypeMirror typeMirror : e.getInterfaces()) {
                TypeModel iface = this.typeFactory.create(typeMirror, elementUtils);
                if (iface.getFullName().startsWith("java")) continue;
                superTypes.add(iface.getFullName());
            }
        }
        TypeModel c = this.typeFactory.create(e.asType(), elementUtils);
        BeanModel beanModel = new BeanModel(this.configuration.getNamePrefix(), c, superTypes);
        List<? extends Element> elements = e.getEnclosedElements();
        for (ExecutableElement constructor : ElementFilter.constructorsIn(elements)) {
            if (!this.configuration.isValidConstructor(constructor)) continue;
            ArrayList<ParameterModel> parameters = new ArrayList<ParameterModel>(constructor.getParameters().size());
            for (VariableElement variableElement : constructor.getParameters()) {
                TypeModel typeModel2 = this.typeFactory.create(variableElement.asType(), elementUtils);
                parameters.add(new ParameterModel(beanModel, variableElement.getSimpleName().toString(), typeModel2));
            }
            beanModel.addConstructor(new ConstructorModel(parameters));
        }
        VisitorConfig config = this.configuration.getConfig(e, elements);
        HashSet<String> blockedProperties = new HashSet<String>();
        HashMap<String, PropertyModel> properties = new HashMap<String, PropertyModel>();
        HashMap<String, TypeCategory> types = new HashMap<String, TypeCategory>();
        if (config.isVisitFields()) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(elements)) {
                name = variableElement.getSimpleName().toString();
                if (this.configuration.isValidField(variableElement)) {
                    try {
                        typeModel = this.typeFactory.create(variableElement.asType(), elementUtils);
                        if (variableElement.getAnnotation(QueryType.class) != null) {
                            typeCategory = TypeCategory.get((PropertyType)variableElement.getAnnotation(QueryType.class).value());
                            if (typeCategory == null) {
                                blockedProperties.add(name);
                                continue;
                            }
                            typeModel = typeModel.as(typeCategory);
                            types.put(name, typeCategory);
                        }
                        inits = new String[]{};
                        if (variableElement.getAnnotation(QueryInit.class) != null) {
                            inits = variableElement.getAnnotation(QueryInit.class).value();
                        }
                        properties.put(name, new PropertyModel(beanModel, name, typeModel, inits));
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        builder = new StringBuilder();
                        builder.append("Caught exception for field ");
                        builder.append(c.getFullName()).append("#").append(variableElement.getSimpleName());
                        throw new RuntimeException(builder.toString(), ex);
                    }
                }
                blockedProperties.add(name);
            }
        }
        if (config.isVisitMethods()) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(elements)) {
                name = executableElement.getSimpleName().toString();
                if (name.startsWith("get") && executableElement.getParameters().isEmpty()) {
                    name = StringUtils.uncapitalize((String)name.substring(3));
                } else {
                    if (!name.startsWith("is") || !executableElement.getParameters().isEmpty()) continue;
                    name = StringUtils.uncapitalize((String)name.substring(2));
                }
                if (this.configuration.isValidGetter(executableElement)) {
                    try {
                        typeModel = this.typeFactory.create(executableElement.getReturnType(), elementUtils);
                        if (executableElement.getAnnotation(QueryType.class) != null) {
                            typeCategory = TypeCategory.get((PropertyType)executableElement.getAnnotation(QueryType.class).value());
                            if (typeCategory == null) {
                                blockedProperties.add(name);
                                continue;
                            }
                            if (blockedProperties.contains(name)) continue;
                            typeModel = typeModel.as(typeCategory);
                        } else if (types.containsKey(name)) {
                            typeModel = typeModel.as((TypeCategory)types.get(name));
                        }
                        inits = new String[]{};
                        if (executableElement.getAnnotation(QueryInit.class) != null) {
                            inits = executableElement.getAnnotation(QueryInit.class).value();
                        }
                        properties.put(name, new PropertyModel(beanModel, name, typeModel, inits));
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        builder = new StringBuilder();
                        builder.append("Caught exception for method ");
                        builder.append(c.getFullName()).append("#").append(executableElement.getSimpleName());
                        throw new RuntimeException(builder.toString(), ex);
                    }
                }
                blockedProperties.add(name);
            }
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (blockedProperties.contains(entry.getKey())) continue;
            beanModel.addProperty((PropertyModel)entry.getValue());
        }
        return beanModel;
    }
}

