/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt.jpa;

import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.VisitorConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class JPAConfiguration
extends Configuration {
    private List<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();

    public JPAConfiguration(Class<? extends Annotation> entityAnn, Class<? extends Annotation> superTypeAnn, Class<? extends Annotation> embeddableAnn, Class<? extends Annotation> dtoAnn, Class<? extends Annotation> skipAnn) throws ClassNotFoundException {
        super(entityAnn, superTypeAnn, embeddableAnn, dtoAnn, skipAnn);
        for (String simpleName : Arrays.asList("Column", "Embedded", "EmbeddedId", "GeneratedValue", "Id", "JoinColumn", "ManyToOne", "OneToMany", "PrimaryKeyJoinColumn")) {
            this.annotations.add(Class.forName("javax.persistence." + simpleName));
        }
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        boolean fields = false;
        boolean methods = false;
        for (Element element : elements) {
            if (element.getKind().equals((Object)ElementKind.FIELD)) {
                if (fields || !this.hasJPAAnnotation(element)) continue;
                fields = true;
                continue;
            }
            if (!element.getKind().equals((Object)ElementKind.METHOD) || methods || !this.hasJPAAnnotation(element)) continue;
            methods = true;
        }
        if (fields && !methods) {
            return VisitorConfig.FIELDS_ONLY;
        }
        if (methods && !fields) {
            return VisitorConfig.METHODS_ONLY;
        }
        return VisitorConfig.ALL;
    }

    private boolean hasJPAAnnotation(Element element) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (element.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }
}

