/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.commons.lang.Assert;
import com.mysema.query.apt.APTModelFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.DTOElementVisitor;
import com.mysema.query.apt.EntityElementVisitor;
import com.mysema.query.codegen.ClassModel;
import com.mysema.query.codegen.ClassModelFactory;
import com.mysema.query.codegen.ClassUtil;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.Serializers;
import com.mysema.query.codegen.TypeModelFactory;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import net.jcip.annotations.Immutable;

@Immutable
public class Processor {
    private final ProcessingEnvironment env;
    private final APTModelFactory typeFactory;
    private final String namePrefix = "Q";
    private final Configuration conf;
    private final ClassModelFactory classModelFactory;

    public Processor(ProcessingEnvironment env, Configuration configuration) {
        this.conf = configuration;
        List<Class<Annotation>> anns = this.conf.getEmbeddableAnn() != null ? Arrays.asList(this.conf.getEntityAnn(), this.conf.getEmbeddableAnn()) : Arrays.asList(this.conf.getEntityAnn());
        this.env = (ProcessingEnvironment)Assert.notNull((Object)env);
        TypeModelFactory factory = new TypeModelFactory(anns);
        this.typeFactory = new APTModelFactory(factory, anns);
        this.classModelFactory = this.conf.getSkipAnn() != null ? new ClassModelFactory(factory, this.conf.getSkipAnn()) : new ClassModelFactory(factory);
    }

    public void process(RoundEnvironment roundEnv) {
        HashMap<String, ClassModel> superTypes = new HashMap<String, ClassModel>();
        EntityElementVisitor entityVisitor = new EntityElementVisitor(this.env, this.conf, "Q", this.typeFactory);
        if (this.conf.getSuperTypeAnn() != null) {
            for (Element element : roundEnv.getElementsAnnotatedWith(this.conf.getSuperTypeAnn())) {
                ClassModel classModel = element.accept(entityVisitor, null);
                superTypes.put(classModel.getName(), classModel);
            }
            for (ClassModel classModel : superTypes.values()) {
                this.addSupertypeFields(classModel, superTypes);
            }
            if (!superTypes.isEmpty()) {
                this.serialize(Serializers.SUPERTYPE, superTypes);
            }
        }
        HashMap<String, ClassModel> entityTypes = new HashMap<String, ClassModel>();
        for (Element element : roundEnv.getElementsAnnotatedWith(this.conf.getEntityAnn())) {
            ClassModel classModel = element.accept(entityVisitor, null);
            entityTypes.put(classModel.getName(), classModel);
        }
        for (ClassModel classModel : entityTypes.values()) {
            this.addSupertypeFields(classModel, superTypes, entityTypes);
        }
        if (!entityTypes.isEmpty()) {
            this.serialize(Serializers.ENTITY, entityTypes);
        }
        if (this.conf.getEmbeddableAnn() != null) {
            HashMap<String, ClassModel> hashMap = new HashMap<String, ClassModel>();
            for (Element element : roundEnv.getElementsAnnotatedWith(this.conf.getEmbeddableAnn())) {
                ClassModel classModel = element.accept(entityVisitor, null);
                hashMap.put(classModel.getName(), classModel);
            }
            for (ClassModel classModel : hashMap.values()) {
                this.addSupertypeFields(classModel, superTypes, hashMap);
            }
            if (!hashMap.isEmpty()) {
                this.serialize(Serializers.EMBEDDABLE, hashMap);
            }
        }
        if (this.conf.getDtoAnn() != null) {
            DTOElementVisitor dTOElementVisitor = new DTOElementVisitor(this.env, this.conf, "Q", this.typeFactory);
            HashMap<String, ClassModel> hashMap = new HashMap<String, ClassModel>();
            for (Element element : roundEnv.getElementsAnnotatedWith(this.conf.getDtoAnn())) {
                ClassModel model = element.accept(dTOElementVisitor, null);
                hashMap.put(model.getName(), model);
            }
            if (!hashMap.isEmpty()) {
                this.serialize(Serializers.DTO, hashMap);
            }
        }
    }

    private void addSupertypeFields(ClassModel model, Map<String, ClassModel> ... superTypes) {
        Class superClass;
        String stype = model.getSupertypeName();
        for (Map<String, ClassModel> stypes : superTypes) {
            if (!stypes.containsKey(stype)) continue;
            while (stypes.containsKey(stype)) {
                ClassModel sdecl = stypes.get(stype);
                if (stype.equals(model.getSupertypeName())) {
                    model.setSuperModel(sdecl);
                }
                model.include(sdecl);
                stype = sdecl.getSupertypeName();
            }
        }
        if (!(model.getSuperModel() != null || (superClass = ClassUtil.safeClassForName((String)(stype = model.getSupertypeName()))) == null || superClass.equals(Object.class) || this.conf.getSuperTypeAnn() != null && superClass.getAnnotation(this.conf.getSuperTypeAnn()) == null && superClass.getAnnotation(this.conf.getEntityAnn()) == null)) {
            ClassModel type = this.classModelFactory.create(superClass, "Q");
            model.include(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(Serializer serializer, Map<String, ClassModel> types) {
        Messager msg = this.env.getMessager();
        for (ClassModel type : types.values()) {
            msg.printMessage(Diagnostic.Kind.NOTE, type.getName() + " is processed");
            try {
                String packageName = type.getPackageName();
                String className = packageName + "." + "Q" + type.getSimpleName();
                JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
                Writer writer = fileObject.openWriter();
                try {
                    serializer.serialize(type, writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (Exception e) {
                msg.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
    }
}

