/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.maven.apt;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractProcessorMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String[] processors;
    protected String processor;
    protected String sourceEncoding;
    protected Map<String, String> options;
    protected Map<String, String> compilerOptions;
    protected boolean showWarnings = false;
    protected boolean logOnlyOnError = false;
    private List<Artifact> pluginArtifacts;

    private String buildCompileClasspath() {
        List pathElements = null;
        try {
            pathElements = this.isForTest() ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            super.getLog().warn((CharSequence)"exception calling getCompileClasspathElements", (Throwable)e);
            return null;
        }
        if (this.pluginArtifacts != null) {
            for (Artifact a : this.pluginArtifacts) {
                if (a.getFile() == null) continue;
                pathElements.add(a.getFile().getAbsolutePath());
            }
        }
        if (pathElements.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (i = 0; i < pathElements.size() - 1; ++i) {
            result.append((String)pathElements.get(i)).append(File.pathSeparatorChar);
        }
        result.append((String)pathElements.get(i));
        return result.toString();
    }

    private String buildProcessor() {
        if (this.processors != null) {
            StringBuilder result = new StringBuilder();
            for (String processor : this.processors) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(processor);
            }
            return result.toString();
        }
        if (this.processor != null) {
            return this.processor;
        }
        String error = "Either processor or processors need to be given";
        this.getLog().error((CharSequence)error);
        throw new IllegalArgumentException(error);
    }

    public void execute() throws MojoExecutionException {
        if (this.getOutputDirectory() != null && !this.getOutputDirectory().exists()) {
            this.getOutputDirectory().mkdirs();
        }
        try {
            JavaCompiler.CompilationTask task;
            Boolean rv;
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            List files = FileUtils.getFiles((File)this.getSourceDirectory(), (String)"**/*.java", null);
            Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(files);
            String compileClassPath = this.buildCompileClasspath();
            String processor = this.buildProcessor();
            LinkedHashMap<String, String> compilerOpts = new LinkedHashMap<String, String>();
            compilerOpts.put("cp", compileClassPath);
            if (this.sourceEncoding != null) {
                compilerOpts.put("encoding", this.sourceEncoding);
            }
            compilerOpts.put("proc:only", null);
            compilerOpts.put("processor", processor);
            if (this.options != null) {
                for (Map.Entry<String, String> entry : this.options.entrySet()) {
                    compilerOpts.put("A" + entry.getKey() + "=" + entry.getValue(), null);
                }
            }
            if (this.getOutputDirectory() != null) {
                compilerOpts.put("s", this.getOutputDirectory().getPath());
            }
            if (!this.showWarnings) {
                compilerOpts.put("nowarn", null);
            }
            compilerOpts.put("sourcepath", this.getSourceDirectory().getCanonicalPath());
            if (this.compilerOptions != null) {
                compilerOpts.putAll(this.compilerOptions);
            }
            ArrayList<String> opts = new ArrayList<String>(compilerOpts.size() * 2);
            for (Map.Entry compilerOption : compilerOpts.entrySet()) {
                opts.add("-" + (String)compilerOption.getKey());
                String value = (String)compilerOption.getValue();
                if (!StringUtils.isNotBlank((String)value)) continue;
                opts.add(value);
            }
            StringWriter out = null;
            if (this.logOnlyOnError) {
                out = new StringWriter();
            }
            if ((rv = (task = compiler.getTask(out, fileManager, null, opts, null, compilationUnits1)).call()).equals(Boolean.FALSE) && this.logOnlyOnError) {
                this.getLog().error((CharSequence)((Object)out).toString());
            }
            if (this.getOutputDirectory() != null) {
                if (this.isForTest()) {
                    this.project.addTestCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
                } else {
                    this.project.addCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
                }
            }
        }
        catch (Exception e1) {
            super.getLog().error((CharSequence)"execute error", (Throwable)e1);
            throw new MojoExecutionException(e1.getMessage());
        }
    }

    protected abstract File getSourceDirectory();

    protected abstract File getOutputDirectory();

    protected boolean isForTest() {
        return false;
    }
}

